/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.gui.GuiUtils;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;

public class ProjectInfoPanel
extends BasePanel {
    private static final String TAG = "ProjectInfoPanel";
    private static final int LINK_COLOR = -10969610;
    private static final int LINK_HOVER_COLOR = -8145417;
    private final List<Rectangle> linkBounds = new ArrayList<Rectangle>();
    private final List<String> linkUrls = new ArrayList<String>();

    public ProjectInfoPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        this.linkBounds.clear();
        this.linkUrls.clear();
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int lineHeight = this.fontRendererObj.field_78288_b + 3;
        int sectionSpacing = 15;
        int contentWidth = this.mc.field_71462_r.field_146294_l - (panelX + padding * 2) - 100;
        this.fontRendererObj.func_78276_b("CedarServerLocalizer", contentX, y, -415707);
        String versionString = "v0.4-beta";
        this.fontRendererObj.func_78276_b(versionString, contentX + this.fontRendererObj.func_78256_a("CedarServerLocalizer") + 5, y, -7433577);
        this.fontRendererObj.func_78279_b("\u4e00\u4e2a\u5f3a\u5927\u7684 Minecraft \u670d\u52a1\u5668\u5185\u5bb9\u672c\u5730\u5316\u7ffb\u8bd1\u6a21\u7ec4\uff0c\u8ba9\u60a8\u8f7b\u677e\u7545\u73a9\u56fd\u9645\u670d\u52a1\u5668\uff01", contentX, y += lineHeight, contentWidth, -1);
        GuiUtils.drawHorizontalLine(contentX, contentX + contentWidth, y += lineHeight * 3, 0x50FFFFFF);
        y += sectionSpacing;
        y = this.drawSectionHeader("\u6838\u5fc3\u529f\u80fd", contentX, y, lineHeight);
        y = this.drawBulletPoint("\u5b9e\u65f6\u7ffb\u8bd1\u7269\u54c1\u540d\u79f0\u548c\u63cf\u8ff0", contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint("\u667a\u80fd\u7ffb\u8bd1\u804a\u5929\u5185\u5bb9\uff0c\u652f\u6301\u6d41\u5f0f\u54cd\u5e94", contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint("\u53ef\u89c6\u5316\u914d\u7f6e\u754c\u9762\uff0c\u652f\u6301\u70ed\u91cd\u8f7d", contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint("\u517c\u5bb9\u6240\u6709 OpenAI \u63a5\u53e3\u6807\u51c6\u7684 API", contentX, y, lineHeight, contentWidth);
        y += sectionSpacing;
        y = this.drawSectionHeader("\u8054\u7cfb\u4e0e\u652f\u6301", contentX, y, lineHeight);
        this.drawLink("GitHub \u4ed3\u5e93: ", "CedarXuesong/ServerLocalizer", "https://github.com/CedarXuesong/ServerLocalizer", contentX, y, mouseX, localMouseY);
        this.drawLink("\u95ee\u9898\u4e0e\u53cd\u9988: ", "\u63d0\u4ea4 Issue", "https://github.com/CedarXuesong/ServerLocalizer/issues", contentX, y += lineHeight, mouseX, localMouseY);
        this.drawLink("Bilibili: ", "\u96ea\u677eCedarXuesong", "https://space.bilibili.com/473773611", contentX, y += lineHeight, mouseX, localMouseY);
        y += sectionSpacing;
        y = this.drawSectionHeader("\u5982\u4f55\u8d21\u732e", contentX, y, lineHeight);
        this.fontRendererObj.func_78279_b("\u6211\u4eec\u6b22\u8fce\u5404\u79cd\u5f62\u5f0f\u7684\u8d21\u732e\uff0c\u5305\u62ec\u63d0\u4ea4Bug\u3001\u6539\u8fdb\u7ffb\u8bd1\u6216\u6dfb\u52a0\u65b0\u529f\u80fd\u3002\u8bf7\u901a\u8fc7 Fork \u4ed3\u5e93\u5e76\u53d1\u8d77 Pull Request \u6765\u63d0\u4ea4\u60a8\u7684\u66f4\u6539\u3002", contentX, y, contentWidth, -1);
    }

    private int drawSectionHeader(String text, int x, int y, int lineHeight) {
        this.fontRendererObj.func_78276_b(EnumChatFormatting.YELLOW + text, x, y, -415707);
        return y + lineHeight + 2;
    }

    private int drawBulletPoint(String text, int x, int y, int lineHeight, int wrapWidth) {
        this.fontRendererObj.func_78276_b("\u2022", x, y, -415707);
        this.fontRendererObj.func_78279_b(text, x + 10, y, wrapWidth - 10, -1);
        int lines = this.fontRendererObj.func_78271_c(text, wrapWidth - 10).size();
        return y + lineHeight * lines;
    }

    private void drawLink(String label, String linkText, String url, int x, int y, int mouseX, int localMouseY) {
        this.fontRendererObj.func_78276_b(label, x, y, -1);
        int linkX = x + this.fontRendererObj.func_78256_a(label);
        int linkWidth = this.fontRendererObj.func_78256_a(linkText);
        boolean isHovered = mouseX >= linkX && mouseX < linkX + linkWidth && localMouseY >= y && localMouseY < y + this.fontRendererObj.field_78288_b;
        this.fontRendererObj.func_78276_b(linkText, linkX, y, isHovered ? -8145417 : -10969610);
        if (isHovered) {
            GuiUtils.drawHorizontalLine(linkX, linkX + linkWidth, y + this.fontRendererObj.field_78288_b, -8145417);
        }
        this.linkBounds.add(new Rectangle(linkX, y, linkWidth, this.fontRendererObj.field_78288_b));
        this.linkUrls.add(url);
    }

    private void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            mylog.error(TAG, "\u65e0\u6cd5\u6253\u5f00\u94fe\u63a5: " + url, e);
        }
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        for (int i = 0; i < this.linkBounds.size(); ++i) {
            if (!this.linkBounds.get(i).contains(mouseX, localMouseY)) continue;
            this.drawHoveringText(Collections.singletonList(EnumChatFormatting.GRAY + "\u70b9\u51fb\u6253\u5f00: " + this.linkUrls.get(i)), mouseX, mouseY);
            return;
        }
    }

    @Override
    public int getContentHeight() {
        return 280;
    }

    @Override
    public void saveConfig() {
    }

    @Override
    public void resetConfig() {
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
    }

    @Override
    public void mouseClicked(int mouseX, int localMouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, localMouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < this.linkBounds.size(); ++i) {
                if (!this.linkBounds.get(i).contains(mouseX, localMouseY)) continue;
                this.openUrl(this.linkUrls.get(i));
                return;
            }
        }
    }
}

