/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.IChatComponent;

public class ChatMessageCache {
    private static ChatMessageCache instance;
    private final ConcurrentHashMap<String, IChatComponent> messageCache = new ConcurrentHashMap();

    private ChatMessageCache() {
    }

    public static synchronized ChatMessageCache getInstance() {
        if (instance == null) {
            instance = new ChatMessageCache();
        }
        return instance;
    }

    public void cacheMessage(String messageId, IChatComponent component) {
        this.messageCache.put(messageId, component);
    }

    public IChatComponent getCachedMessage(String messageId) {
        return this.messageCache.get(messageId);
    }

    public void clearCache() {
        this.messageCache.clear();
    }
}

