/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import java.io.File;
import java.util.Objects;

public class ItemTranslationConfig {
    private static final String BASE_DIR = "config/serverlocalizer/language_packs/";
    public static final String ITEM_TRANSLATION_FILE = "config/serverlocalizer/language_packs/item.json";

    public static void ensureDirectoryExists() {
        File dir = new File(BASE_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static String getConfigRoot() {
        return BASE_DIR;
    }

    public static String getTranslationFile(TranslationModule module) {
        if (Objects.requireNonNull(module) == TranslationModule.ITEM) {
            return ITEM_TRANSLATION_FILE;
        }
        return "config/serverlocalizer/language_packs/default.json";
    }

    static {
        ItemTranslationConfig.ensureDirectoryExists();
    }

    public static enum TranslationModule {
        ITEM;

    }
}

