/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationConfig;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationManager;
import com.cedarxuesong.serverlocalizer.utils.translation.ModuleTranslationManager;
import com.cedarxuesong.serverlocalizer.utils.translation.TextProcessor;

public class ItemTranslator {
    private static final String TAG = "ItemTranslator";
    private final ItemTranslationManager translationManager = ModuleTranslationManager.getInstance().getTranslationManager(ItemTranslationConfig.TranslationModule.ITEM);

    public String translate(String originalText) {
        if (originalText == null || originalText.isEmpty()) {
            return originalText;
        }
        try {
            TextProcessor.TemplateResult templateResult = TextProcessor.convertToTemplate(originalText);
            String template = templateResult.getTemplate();
            String translatedTemplate = this.translationManager.findTranslation(template);
            if (translatedTemplate == null) {
                this.translationManager.addOrUpdateTranslation(template, "");
                return originalText;
            }
            if (translatedTemplate.isEmpty()) {
                return originalText;
            }
            return TextProcessor.fillTemplate(translatedTemplate, templateResult.getDynamicContent());
        }
        catch (Exception e) {
            mylog.error(TAG, "\u7ffb\u8bd1\u7269\u54c1\u6587\u672c\u65f6\u53d1\u751f\u9519\u8bef: " + originalText, e);
            return originalText;
        }
    }

    public int getTranslationCount() {
        return this.translationManager.getTranslationCount();
    }
}

