/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.extend.container;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.w3c.dom.Element;

public class EScrollContainer<C extends Component>
extends ScrollContainer<C> {
    public static final int SCROLLBAR_THICCNESS = 5;
    protected boolean preventShiftScroll = false;
    protected boolean flipScroll = false;

    public EScrollContainer(ScrollContainer.ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child, boolean flipScroll) {
        super(direction, horizontalSizing, verticalSizing, child);
        this.flipScroll(flipScroll);
        this.scrollbarThiccness(5);
        this.scrollbar(this.styledScrollbar());
        Insets oldPadding = (Insets)this.padding.get();
        this.updateScrollPadding(oldPadding);
    }

    public ScrollContainer.Scrollbar styledScrollbar() {
        boolean isOverrideScrollbar = FzmmClient.CONFIG.guiStyle.persistentScrollbar();
        return isOverrideScrollbar ? this.vanillaFlat(this.flipScroll) : this.flat(Color.WHITE, this.flipScroll);
    }

    public boolean preventShiftScroll() {
        return this.preventShiftScroll;
    }

    public void preventShiftScroll(boolean isShiftRequired) {
        this.preventShiftScroll = isShiftRequired;
    }

    public boolean flipScroll() {
        return this.flipScroll;
    }

    private void flipScroll(boolean flip) {
        this.flipScroll = flip;
    }

    private void updateScrollPadding(Insets oldPadding) {
        if (this.direction == ScrollContainer.ScrollDirection.VERTICAL) {
            this.padding(this.flipScroll ? oldPadding.withLeft(this.scrollbarThiccness) : oldPadding.withRight(this.scrollbarThiccness));
        } else {
            this.padding(this.flipScroll ? oldPadding.withTop(this.scrollbarThiccness) : oldPadding.withBottom(this.scrollbarThiccness));
        }
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        this.scrollbarOffset = this.direction == ScrollContainer.ScrollDirection.VERTICAL ? this.getScrollbarX(this.flipScroll, this.scrollbarOffset) : this.getScrollbarY(this.flipScroll, this.scrollbarOffset);
    }

    protected boolean isInScrollbar(double mouseX, double mouseY) {
        return super.isInScrollbar(mouseX, mouseY) && this.direction.choose(mouseY, mouseX) <= (double)(this.scrollbarOffset + this.scrollbarThiccness);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        if (this.preventShiftScroll && class_437.method_25442()) {
            return false;
        }
        return super.onMouseScroll(mouseX, mouseY, amount);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"prevent-shift-scroll", UIParsing::parseBool, this::preventShiftScroll);
    }

    public static EScrollContainer<?> parse(Element element) {
        boolean flipScroll = element.hasAttribute("flip-scroll") && element.getAttribute("flip-scroll").equals("true");
        return element.getAttribute("direction").equals("vertical") ? EContainers.verticalScroll(Sizing.content(), Sizing.content(), null, flipScroll) : EContainers.horizontalScroll(Sizing.content(), Sizing.content(), null, flipScroll);
    }

    public ScrollContainer.Scrollbar flat(Color color, boolean flipScroll) {
        int scrollbarColor = color.argb();
        return (context, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
            if (!active) {
                return;
            }
            if (direction == ScrollContainer.ScrollDirection.HORIZONTAL) {
                y = this.getScrollbarY(flipScroll, y);
            } else {
                x = this.getScrollbarX(flipScroll, x);
            }
            float progress = Easing.SINE.apply((float)class_3532.method_53062((long)(lastInteractTime - class_156.method_659()), (long)0L, (long)750L) / 750.0f);
            int alpha = (int)(progress * (float)(scrollbarColor >>> 24));
            context.method_25294(x, y, x + width, y + height, alpha << 24 | scrollbarColor & 0xFFFFFF);
        };
    }

    public ScrollContainer.Scrollbar vanillaFlat(boolean flipScroll) {
        return (context, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
            if (!(direction == ScrollContainer.ScrollDirection.HORIZONTAL && width < trackWidth || direction == ScrollContainer.ScrollDirection.VERTICAL && height < trackHeight)) {
                return;
            }
            if (direction == ScrollContainer.ScrollDirection.HORIZONTAL) {
                y = this.getScrollbarY(flipScroll, y);
                trackY = this.getScrollbarY(flipScroll, trackY);
            } else {
                x = this.getScrollbarX(flipScroll, x);
                trackX = this.getScrollbarX(flipScroll, trackX);
            }
            context.method_25294(trackX, trackY, trackX + trackWidth, trackY + trackHeight, Color.BLACK.argb());
            NinePatchTexture.draw((class_2960)FLAT_VANILLA_SCROLLBAR_TEXTURE, (OwoUIDrawContext)context, (int)x, (int)y, (int)width, (int)height);
        };
    }

    private int getScrollbarX(boolean flipScroll, int x) {
        return flipScroll ? this.x() : x + this.scrollbarThiccness;
    }

    private int getScrollbarY(boolean flipScroll, int y) {
        return flipScroll ? this.y() : y + this.scrollbarThiccness;
    }
}

