/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.snack_bar;

import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.EBooleanButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;

public class SnackBarBuilder {
    private final ISnackBarComponent snackBar;
    private Color backgroundColor = EStyles.ALERT_SUCCESS_COLOR;
    private final LabelComponent title;
    private LabelComponent details;
    private final List<ButtonComponent> buttons = new ArrayList<ButtonComponent>();
    private Sizing horizontalSizing = Sizing.content();
    private Sizing verticalSizing = Sizing.content();
    private boolean closeButton = false;
    private boolean timerEnabled = false;
    private boolean detailsExpanded = false;
    private boolean keepOnLimit = false;
    private long timerMillis = -1L;
    private String id = "generic";

    private SnackBarBuilder(ISnackBarComponent snackBar, LabelComponent title, LabelComponent details) {
        this.snackBar = snackBar;
        this.title = title;
        this.details = details;
    }

    public static SnackBarBuilder builder(ISnackBarComponent snackBar, String id) {
        return SnackBarBuilder.builder(snackBar, EComponents.label((class_2561)class_2561.method_43473()), null, id);
    }

    public static SnackBarBuilder builder(ISnackBarComponent snackBar, LabelComponent title, LabelComponent details, String id) {
        return new SnackBarBuilder(snackBar, title, details).id(id);
    }

    public SnackBarBuilder title(class_2561 text) {
        this.title.text(text);
        return this;
    }

    public SnackBarBuilder backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public SnackBarBuilder details(class_2561 details) {
        if (this.details == null) {
            this.details = EComponents.label((class_2561)class_2561.method_43473());
        }
        this.details.text(details);
        return this;
    }

    public SnackBarBuilder expandDetails() {
        this.detailsExpanded = true;
        return this;
    }

    public SnackBarBuilder button(Function<ISnackBarComponent, ButtonComponent> function) {
        ButtonComponent button = function.apply(this.snackBar);
        button.verticalSizing(Sizing.fixed((int)16));
        button.margins(Insets.bottom((int)2));
        this.buttons.add(button);
        return this;
    }

    public SnackBarBuilder lowTimer() {
        return this.customTimer(5L, TimeUnit.SECONDS);
    }

    public SnackBarBuilder mediumTimer() {
        return this.customTimer(10L, TimeUnit.SECONDS);
    }

    public SnackBarBuilder highTimer() {
        return this.customTimer(20L, TimeUnit.SECONDS);
    }

    public SnackBarBuilder customTimer(long amount, TimeUnit unit) {
        this.timerMillis = TimeUnit.MILLISECONDS.convert(amount, unit);
        return this;
    }

    public SnackBarBuilder sizing(Sizing horizontalSizing, Sizing verticalSizing) {
        this.horizontalSizing = horizontalSizing;
        this.verticalSizing = verticalSizing;
        return this;
    }

    public SnackBarBuilder startTimer() {
        this.timerEnabled = true;
        return this;
    }

    public SnackBarBuilder closeButton() {
        this.closeButton = true;
        return this;
    }

    public SnackBarBuilder keepOnLimit() {
        this.keepOnLimit = true;
        return this;
    }

    public SnackBarBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ISnackBarComponent build() {
        ISnackBarComponent result = this.snackBar;
        ArrayList<ButtonComponent> buttons = new ArrayList<ButtonComponent>(this.buttons);
        result.surface(Surface.flat((int)this.backgroundColor.argb()));
        FlowLayout layout = (FlowLayout)EContainers.verticalFlow(Sizing.content(), Sizing.content()).gap(1).padding(Insets.of((int)3)).horizontalAlignment(HorizontalAlignment.LEFT);
        EFlowLayout firstRow = EContainers.ltrTextFlow(Sizing.expand((int)100), Sizing.content());
        firstRow.gap(2);
        firstRow.verticalAlignment(VerticalAlignment.CENTER);
        layout.child((Component)firstRow);
        if (!this.buttons.isEmpty()) {
            EFlowLayout secondRow = EContainers.ltrTextFlow(Sizing.expand((int)100), Sizing.content());
            secondRow.children(this.buttons);
            secondRow.gap(4);
            layout.child((Component)secondRow);
        }
        if (this.details != null && !this.details.text().toString().isEmpty()) {
            EFlowLayout detailsLayout = EContainers.verticalFlow(Sizing.content(), Sizing.content());
            layout.child((Component)detailsLayout);
            EBooleanButton detailsButton = this.getDetailsButton(detailsLayout);
            buttons.add(detailsButton);
            firstRow.child((Component)detailsButton);
        }
        firstRow.child((Component)this.title.margins(Insets.vertical((int)2)));
        if (this.closeButton) {
            ButtonComponent button = Components.button((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.close"), buttonComponent -> result.close());
            button.sizing(Sizing.fixed((int)14));
            button.positioning(Positioning.relative((int)100, (int)0));
            button.renderer(ButtonComponent.Renderer.flat((int)0, (int)0x40000000, (int)0));
            buttons.add(button);
            firstRow.horizontalSizing(Sizing.expand((int)100));
            firstRow.child((Component)button);
        }
        if (this.horizontalSizing.isContent()) {
            int width = class_310.method_1551().field_1772.method_27525((class_5348)this.title.text());
            int firstRowChildrenSize = firstRow.children().size() - 1;
            width += 14 * firstRowChildrenSize;
            width += firstRow.gap() * firstRowChildrenSize;
            this.horizontalSizing = Sizing.fixed((int)(width += ((Insets)layout.padding().get()).horizontal()));
        }
        layout.sizing(this.horizontalSizing, this.verticalSizing);
        result.sizing(this.horizontalSizing, this.verticalSizing);
        result.setTimer(this.timerMillis);
        result.id(this.id);
        result.add((Component)layout);
        if (this.timerEnabled) {
            result.startTimer();
        }
        if (this.keepOnLimit) {
            this.snackBar.removeOnLimit(false);
        }
        result.setButtons(buttons);
        return result;
    }

    private EBooleanButton getDetailsButton(FlowLayout detailsLayout) {
        EBooleanButton button = new EBooleanButton((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.expand.expanded"), (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.expand.collapsed"));
        button.renderer(ButtonComponent.Renderer.flat((int)0, (int)0x40000000, (int)0));
        button.sizing(Sizing.fixed((int)14));
        this.details.horizontalSizing(Sizing.expand((int)100));
        button.onPress(buttonComponent -> {
            if (button.enabled()) {
                detailsLayout.child((Component)this.details);
            } else {
                detailsLayout.removeChild((Component)this.details);
            }
        });
        if (this.detailsExpanded) {
            button.enabled(true);
        }
        return button;
    }
}

