/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.tabs;

import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.component.EButtonComponent;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.tabs.ITab;
import fzmm.zailer.me.client.logic.history.IMemento;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class TabContainer
extends EFlowLayout {
    private final HashMap<String, Component> tabs = new HashMap();
    private final EFlowLayout tabsView;
    private final List<ITab> parsedTabs = new ArrayList<ITab>();
    private EFlowLayout contentLayout;
    @Nullable
    private ELabelComponent labelComponent;
    private String selectedTab;
    private Consumer<ITab> onSelect = tab -> {};

    public TabContainer(Sizing horizontalSizing, Sizing verticalSizing, FlowLayout.Algorithm algorithm) {
        super(horizontalSizing, verticalSizing, algorithm);
        this.tabsView = EContainers.horizontalFlow(Sizing.content(), Sizing.content());
        this.gap(4);
    }

    public <T extends Component> T childById(@NotNull Class<T> expectedClass, @NotNull String id) {
        Component result = this.tabsView.childById(expectedClass, id);
        if (result != null) {
            return (T)result;
        }
        return (T)super.childById(expectedClass, id);
    }

    public void selectTab() {
        this.selectTab(this.selectedTab().getId());
    }

    public void selectTab(ITab tab) {
        this.selectTab(tab.getId());
    }

    private void selectTab(String id) {
        Component tabComponent = this.tabs.get(id);
        if (tabComponent == null) {
            throw new NullPointerException("Tab '" + id + "' of '" + this.id() + "' has no component");
        }
        String previousTab = this.selectedTab;
        this.selectedTab = id;
        Object tab = this.selectedTab();
        if (this.labelComponent != null) {
            String translationKey = tab.getTranslationKey();
            this.labelComponent.text((class_2561)class_2561.method_43471((String)translationKey)).tooltip((class_2561)class_2561.method_43471((String)(translationKey + ".tooltip")));
        }
        this.contentLayout.configure(layout -> {
            this.tabsView.removeChild(tabComponent);
            layout.clearChildren();
            layout.child(tabComponent);
            if (previousTab != null) {
                this.tabsView.child(this.tabs.get(previousTab));
            }
            this.onSelect.accept((ITab)tab);
            ParentComponent rootComponent = this.root();
            if (rootComponent == null) {
                return;
            }
            this.updateButton(rootComponent, id, previousTab);
        });
    }

    private void updateButton(ParentComponent rootComponent, String selectedTab, String previousTab) {
        EButtonComponent button = (EButtonComponent)rootComponent.childById(EButtonComponent.class, selectedTab + "-button");
        if (button != null) {
            button.active(false);
        }
        if (previousTab == null || previousTab.equals(selectedTab)) {
            return;
        }
        EButtonComponent previousButton = (EButtonComponent)rootComponent.childById(EButtonComponent.class, previousTab + "-button");
        if (previousButton != null) {
            previousButton.active(true);
        }
    }

    public <T extends ITab> T selectedTab() {
        for (ITab tab : this.parsedTabs) {
            if (!tab.getId().equals(this.selectedTab)) continue;
            return (T)tab;
        }
        return (T)this.parsedTabs.get(0);
    }

    public Set<String> tabIds() {
        return this.tabs.keySet();
    }

    public TabContainer onSelect(Consumer<ITab> onSelect) {
        this.onSelect = onSelect;
        return this;
    }

    public TabContainer setupTabs(EFlowLayout rootComponent, String selectedId) {
        EButtonComponent selectedButton = null;
        for (ITab tab : this.parsedTabs) {
            String id = tab.getId();
            EButtonComponent buttonComponent = rootComponent.childByIdOrThrow(EButtonComponent.class, id + "-button");
            buttonComponent.verticalSizing(Sizing.fixed((int)16));
            buttonComponent.method_25355(tab.getButtonText());
            buttonComponent.onPress(button -> {
                this.selectTab(id);
                for (String tabId : this.tabIds()) {
                    rootComponent.childByIdOrThrow(EButtonComponent.class, tabId + "-button").active(true);
                }
                buttonComponent.active(false);
            });
            tab.setupComponents(rootComponent);
            if (!selectedId.equals(id)) continue;
            selectedButton = buttonComponent;
        }
        if (selectedButton != null) {
            selectedButton.method_25306();
        }
        return this;
    }

    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.backup());
        output.writeObject(this.selectedTab);
    }

    private Map<String, byte[]> backup() {
        HashMap<String, byte[]> mementoTabHashMap = new HashMap<String, byte[]>();
        for (ITab tab : this.parsedTabs) {
            if (!(tab instanceof IMemento)) continue;
            IMemento mementoTab = (IMemento)((Object)tab);
            mementoTabHashMap.put(tab.getId(), mementoTab.backup());
        }
        return mementoTabHashMap;
    }

    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.restore((Map)input.readObject());
        this.selectTab((String)input.readObject());
    }

    private void restore(Map<String, byte[]> mementoTabHashMap) {
        for (ITab tab : this.parsedTabs) {
            if (!(tab instanceof IMemento)) continue;
            IMemento mementoTab = (IMemento)((Object)tab);
            mementoTab.restore(mementoTabHashMap.get(tab.getId()));
        }
    }

    public TabContainer addParsedTabs(List<? extends ITab> tabs) {
        this.parsedTabs.addAll(tabs);
        if (this.parsedTabs.size() != this.tabs.size()) {
            throw new IllegalStateException("Tabs of '" + this.id() + "' are mismatching (expected tabs: " + this.parsedTabs.size() + ", actual components: " + this.tabs.size() + ")");
        }
        for (String tab : this.tabs.keySet()) {
            if (this.tabs.get(tab) != null) continue;
            throw new IllegalStateException("Tab '" + tab + "' of '" + this.id() + "' has no component");
        }
        return this;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        List tabComponentList = UIParsing.get(children, (String)"tabs", e -> UIParsing.allChildrenOfType((Element)e, (short)1)).orElse(Collections.emptyList());
        for (Element tabComponent : tabComponentList) {
            if (tabComponent == null) {
                throw new NullPointerException("Component of tab container '" + this.id() + "' is null");
            }
            Component component = model.parseComponent(Component.class, tabComponent);
            this.tabsView.child(component);
            this.tabs.put(component.id(), component);
        }
        this.labelComponent = this.childById(ELabelComponent.class, "tab-label");
        this.contentLayout = this.childById(EFlowLayout.class, "tab-content");
        if (this.contentLayout == null) {
            this.contentLayout = EContainers.verticalFlow(Sizing.content(), Sizing.content());
            this.child((Component)this.contentLayout);
        }
    }

    public static EFlowLayout parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"direction"});
        return switch (element.getAttribute("direction")) {
            case "horizontal" -> EContainers.tabHorizontal(Sizing.content(), Sizing.content());
            case "ltr-text-flow" -> EContainers.tabLtrTextFlow(Sizing.content(), Sizing.content());
            default -> EContainers.tabVertical(Sizing.content(), Sizing.content());
        };
    }
}

