/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_gallery;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.entity.custom_skin.CustomHeadEntity;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.EItemComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.logic.head_gallery.HeadGalleryResources;
import fzmm.zailer.me.client.logic.head_gallery.MinecraftHeadsData;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.HeadUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1068;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class HeadGalleryScreen
extends BaseFzmmScreen
implements IMemento {
    private static final int SELECTED_TAG_COLOR = 4439218;
    private static final String TAG_BUTTON_TEXT = "fzmm.gui.headGallery.button.tags";
    private static final String TAG_LABEL_TEXT = "fzmm.gui.headGallery.label.tags-overlay";
    private int page;
    private double itemScale;
    private CheckboxComponent styleCheckbox;
    private FlowLayout contentLayout;
    private LabelComponent currentPageLabel;
    private final ObjectArrayList<MinecraftHeadsData> categoryHeads = new ObjectArrayList();
    private final ObjectArrayList<MinecraftHeadsData> categoryHeadsWithFilter = new ObjectArrayList();
    private TextBoxComponent contentSearchField;
    private ButtonComponent tagButton;
    private ButtonComponent clearTagsButton;
    private List<Component> categoryButtonList;
    private Set<String> selectedTags;
    private Set<String> availableTags;
    private LabelComponent errorLabel;
    private String selectedCategory;
    private ScrollContainer<?> contentScroll;
    private CustomHeadEntity frontEntityPreview;
    private CustomHeadEntity backEntityPreview;

    public HeadGalleryScreen(@Nullable class_437 parent) {
        super("head_gallery", "headGallery", parent);
        this.itemScale = FzmmClient.CONFIG.headGallery.itemScale();
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        this.page = 1;
        this.selectedTags = new HashSet<String>();
        this.availableTags = new HashSet<String>();
        assert (this.field_22787 != null);
        this.contentLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "content");
        this.contentScroll = rootComponent.childByIdOrThrow(ScrollContainer.class, "content-scroll");
        this.errorLabel = rootComponent.childByIdOrThrow(LabelComponent.class, "error-message");
        this.currentPageLabel = rootComponent.childByIdOrThrow(LabelComponent.class, "current-page-label");
        ButtonComponent previousPageButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "previous-page-button");
        previousPageButton.onPress(buttonComponent -> this.setPage(this.page - 1));
        previousPageButton.tooltip(List.of(class_2561.method_43471((String)"fzmm.gui.hotkey.single"), class_2561.method_43471((String)"key.keyboard.left")));
        ButtonComponent nextPageButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "next-page-button");
        nextPageButton.onPress(buttonComponent -> this.setPage(this.page + 1));
        nextPageButton.tooltip(List.of(class_2561.method_43471((String)"fzmm.gui.hotkey.single"), class_2561.method_43471((String)"key.keyboard.right")));
        EFlowLayout categoryList = rootComponent.childByIdOrThrow(EFlowLayout.class, "minecraft-heads-category-list");
        this.categoryButtonList = HeadGalleryResources.CATEGORY_LIST.stream().map(category -> Components.button((class_2561)class_2561.method_43471((String)("fzmm.gui.headGallery.button.category." + category)), buttonComponent -> this.categoryButtonExecute((ButtonComponent)buttonComponent, (String)category, null)).renderer(EStyles.DEFAULT_FLAT_BUTTON).sizing(Sizing.fill((int)100), Sizing.fixed((int)16)).id(category)).collect(Collectors.toList());
        categoryList.children(this.categoryButtonList).surface(categoryList.styledPanel()).padding(Insets.of((int)4));
        this.contentSearchField = rootComponent.childByIdOrThrow(TextBoxComponent.class, "content-search");
        this.contentSearchField.onChanged().subscribe(s -> {
            this.applyFilters();
            this.setPage(this.page);
        });
        this.tagButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "tags-button");
        this.tagButton.method_25355(this.getTagButtonText());
        this.tagButton.onPress(this::openTagsExecute);
        this.clearTagsButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "clear-tags");
        this.clearTagsButton.onPress(this::clearTagsExecute);
        SliderWidget scaleSlider = rootComponent.childByIdOrThrow(SliderWidget.class, "item-scale");
        scaleSlider.min(1.0).max(3.0).decimalPlaces(1).setFromDiscreteValue(this.itemScale).scrollStep(1.0 / (scaleSlider.max() + scaleSlider.min()));
        scaleSlider.message(s -> class_2561.method_43469((String)"fzmm.gui.headGallery.option.itemScale", (Object[])new Object[]{s}));
        scaleSlider.onChanged().subscribe(value -> {
            this.itemScale = value;
            this.setPage(this.page);
        });
        this.styleCheckbox = rootComponent.childByIdOrThrow(CheckboxComponent.class, "style-checkbox");
        this.styleCheckbox.checked(FzmmClient.CONFIG.headGallery.setStyleToHeads()).onChanged(value -> this.setPage(this.page));
        rootComponent.childByIdOrThrow(ButtonComponent.class, "minecraft-heads-button").onPress(this::minecraftHeadsExecute);
        FlowLayout previewLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "preview-layout");
        this.frontEntityPreview = new CustomHeadEntity((class_1937)this.field_22787.field_1687);
        this.backEntityPreview = new CustomHeadEntity((class_1937)this.field_22787.field_1687);
        EntityComponent backEntityPreview = EComponents.entity(Sizing.fixed((int)48), this.backEntityPreview).allowMouseRotation(true);
        backEntityPreview.onMouseDrag(0.0, 0.0, 160.0, 0.0, 0);
        backEntityPreview.allowMouseRotation(false);
        previewLayout.child(EComponents.entity(Sizing.fixed((int)48), this.frontEntityPreview));
        previewLayout.child((Component)backEntityPreview);
        this.updatePreview(class_1068.method_62620());
        this.applyFilters();
        this.setPage(1);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.contentSearchField, Component.FocusSource.MOUSE_CLICK);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 263) {
            this.setPage(this.page - 1);
            return true;
        }
        if (keyCode == 262) {
            this.setPage(this.page + 1);
            return true;
        }
        return false;
    }

    private void categoryButtonExecute(ButtonComponent selectedButton, String category, @Nullable Runnable callback) {
        assert (this.field_22787 != null);
        for (Component component : this.categoryButtonList) {
            if (!(component instanceof class_4185)) continue;
            class_4185 button = (class_4185)component;
            button.field_22763 = false;
        }
        this.tagButton.field_22763 = false;
        ((CompletableFuture)HeadGalleryResources.getCategory(category).thenAccept(categoryData -> this.field_22787.execute(() -> {
            this.selectedCategory = category;
            this.categoryHeads.clear();
            this.categoryHeads.addAll((ObjectList)categoryData);
            for (Component component : this.categoryButtonList) {
                if (!(component instanceof class_4185)) continue;
                class_4185 button = (class_4185)component;
                button.field_22763 = true;
            }
            selectedButton.field_22763 = false;
            this.tagButton.field_22763 = true;
            this.updateAvailableTagList((ObjectArrayList<MinecraftHeadsData>)categoryData);
            if (callback == null) {
                this.applyFilters();
                this.setPage(1);
            } else {
                callback.run();
            }
        }))).whenComplete((unused, throwable) -> this.field_22787.execute(() -> {
            if (throwable == null) {
                this.errorLabel.text((class_2561)class_2561.method_43473());
                return;
            }
            this.categoryHeads.clear();
            this.applyFilters();
            this.setPage(1);
            this.errorLabel.text((class_2561)class_2561.method_43469((String)"fzmm.gui.headGallery.label.error", (Object[])new Object[]{category}).method_10862(class_2583.field_24360.method_36139(EStyles.TEXT_ERROR_COLOR.rgb())));
            FzmmClient.LOGGER.error("[HeadGalleryScreen] Error while fetching category '{}'", (Object)category, throwable);
            for (Component component : this.categoryButtonList) {
                if (!(component instanceof class_4185)) continue;
                class_4185 button = (class_4185)component;
                button.field_22763 = true;
            }
        }));
    }

    private void updateAvailableTagList(ObjectArrayList<MinecraftHeadsData> categoryData) {
        HashSet<String> categoryTags = new HashSet<String>();
        for (MinecraftHeadsData minecraftHeadData : categoryData) {
            categoryTags.addAll(minecraftHeadData.tags());
        }
        categoryTags.removeIf(String::isBlank);
        this.selectedTags.clear();
        this.availableTags.clear();
        this.availableTags.addAll(categoryTags);
        this.tagButton.method_25355(this.getTagButtonText());
    }

    private void openTagsExecute(ButtonComponent tagButton) {
        EFlowLayout tagSelectPanel = (EFlowLayout)this.getModel().expandTemplate(EFlowLayout.class, "select-tag", Map.of());
        tagSelectPanel.configure(layout -> {
            FlowLayout tagListLayout = layout.childByIdOrThrow(FlowLayout.class, "minecraft-heads-tags-ltr");
            LabelComponent tagsOverlayLabel = layout.childByIdOrThrow(LabelComponent.class, "tags-overlay-label");
            ButtonComponent clearSelectedTags = layout.childByIdOrThrow(ButtonComponent.class, "clear-tags-overlay");
            tagsOverlayLabel.text(this.getTagLabelText());
            List<Component> buttonList = this.availableTags.stream().sorted().map(tag -> {
                class_5250 text = this.selectedTags.contains(tag) ? this.getSelectedTagText((String)tag) : class_2561.method_43470((String)tag);
                return Components.button((class_2561)text, button -> {
                    this.updateTag((ButtonComponent)button);
                    this.tagOverlayUpdateLabels(tagsOverlayLabel);
                }).horizontalSizing(Sizing.fixed((int)200));
            }).toList();
            tagListLayout.children(buttonList);
            clearSelectedTags.onPress(buttonComponent -> {
                for (Component component : buttonList) {
                    ButtonComponent buttonTag;
                    if (!(component instanceof ButtonComponent) || !this.selectedTags.contains((buttonTag = (ButtonComponent)component).method_25369().getString())) continue;
                    this.updateTag(buttonTag);
                }
                this.tagOverlayUpdateLabels(tagsOverlayLabel);
            });
            TextBoxComponent tagSearchBox = layout.childByIdOrThrow(TextBoxComponent.class, "tag-search");
            tagSearchBox.onChanged().subscribe(value -> {
                ArrayList<Component> buttonListCopy = new ArrayList<Component>(buttonList);
                String valueToLowerCase = value.toLowerCase();
                buttonListCopy.removeIf(tagComponent -> {
                    if (!(tagComponent instanceof ButtonComponent)) {
                        return false;
                    }
                    ButtonComponent buttonTag = (ButtonComponent)tagComponent;
                    String message = buttonTag.method_25369().getString();
                    return !message.toLowerCase().contains(valueToLowerCase) && !this.selectedTags.contains(message);
                });
                tagListLayout.configure(flowLayout -> {
                    flowLayout.clearChildren();
                    flowLayout.children((Collection)buttonListCopy);
                });
            });
        });
        tagSelectPanel.mouseDown().subscribe((mouseX, mouseY, button) -> true);
        OverlayContainer tagOverlay = Containers.overlay((Component)tagSelectPanel);
        this.addOverlay((Component)tagOverlay);
    }

    private void updateTag(ButtonComponent selectedButton) {
        String value = selectedButton.method_25369().getString();
        if (this.selectedTags.contains(value)) {
            this.selectedTags.remove(value);
            selectedButton.method_25355((class_2561)class_2561.method_43470((String)value));
        } else {
            this.selectedTags.add(value);
            selectedButton.method_25355(this.getSelectedTagText(value));
        }
    }

    private void tagOverlayUpdateLabels(LabelComponent tagsOverlayLabel) {
        this.applyFilters();
        this.setPage(this.page);
        this.tagButton.method_25355(this.getTagButtonText());
        tagsOverlayLabel.text(this.getTagLabelText());
    }

    private void clearTagsExecute(ButtonComponent button) {
        this.selectedTags.clear();
        this.tagButton.method_25355(this.getTagButtonText());
        this.applyFilters();
        this.setPage(this.page);
    }

    public void setPage(int page) {
        int maxHeadsPerPage = FzmmClient.CONFIG.headGallery.maxHeadsPerPage();
        if (page < 1) {
            page = 1;
        }
        int firstElementIndex = (page - 1) * maxHeadsPerPage;
        int lastPage = (int)Math.ceil((float)this.categoryHeadsWithFilter.size() / (float)maxHeadsPerPage);
        if (firstElementIndex >= this.categoryHeadsWithFilter.size()) {
            page = lastPage;
            firstElementIndex = this.categoryHeadsWithFilter.isEmpty() ? 0 : (lastPage - 1) * maxHeadsPerPage;
        }
        this.page = page;
        this.currentPageLabel.text((class_2561)class_2561.method_43469((String)"fzmm.gui.headGallery.label.page", (Object[])new Object[]{page, lastPage}));
        int lastElementIndex = Math.min(page * maxHeadsPerPage, this.categoryHeadsWithFilter.size());
        List<EItemComponent> currentPageHeads = this.getPageItems(firstElementIndex, lastElementIndex);
        assert (this.field_22787 != null);
        for (EItemComponent component : currentPageHeads) {
            component.mouseEnter().subscribe(() -> {
                if (this.contentScroll.isInBoundingBox((double)component.x(), (double)component.y())) {
                    this.updatePreview(component.stack());
                }
            });
        }
        this.field_22787.execute(() -> this.contentScroll.configure(component -> {
            this.contentLayout.clearChildren();
            this.contentLayout.children((Collection)currentPageHeads);
        }));
    }

    public List<EItemComponent> getPageItems(int startIndex, int endIndex) {
        ArrayList<EItemComponent> pageItems = new ArrayList<EItemComponent>();
        FzmmConfig config = FzmmClient.CONFIG;
        int nameColor = config.colors.headGalleryName().rgb();
        int tagsColor = config.colors.headGalleryTags().rgb();
        for (int i = startIndex; i != endIndex; ++i) {
            EItemComponent itemComponent;
            MinecraftHeadsData minecraftHeadsData = (MinecraftHeadsData)this.categoryHeadsWithFilter.get(i);
            class_1799 head = HeadBuilder.builder().skinValue(minecraftHeadsData.value()).id(minecraftHeadsData.uuid()).notAddToHistory().get();
            if (this.styleCheckbox.method_20372()) {
                DisplayBuilder builder = DisplayBuilder.of(head);
                builder.setName(class_2561.method_43469((String)"fzmm.item.headGallery.heads.name", (Object[])new Object[]{minecraftHeadsData.name()}).getString(), nameColor).addLore(class_2561.method_43471((String)"fzmm.item.headGallery.heads.tags.title").getString(), tagsColor);
                for (String tag : minecraftHeadsData.tags()) {
                    builder.addLore(class_2561.method_43469((String)"fzmm.item.headGallery.heads.tags.tag", (Object[])new Object[]{tag}).getString(), tagsColor);
                }
                itemComponent = EComponents.itemGive(builder.get());
            } else {
                itemComponent = EComponents.itemGive(head);
                itemComponent.setTooltipFromStack(false);
                itemComponent.tooltip((class_2561)class_2561.method_43470((String)minecraftHeadsData.name()));
            }
            itemComponent.sizing(Sizing.fixed((int)((int)(this.itemScale * 16.0))));
            pageItems.add(itemComponent);
        }
        return pageItems;
    }

    public void applyFilters() {
        if (this.contentSearchField == null) {
            return;
        }
        this.categoryHeadsWithFilter.clear();
        this.categoryHeadsWithFilter.addAll(this.categoryHeads);
        String search = this.contentSearchField.method_1882().toLowerCase();
        this.categoryHeadsWithFilter.removeIf(itemComponent -> !itemComponent.filter(this.selectedTags, search));
        this.clearTagsButton.active(!this.selectedTags.isEmpty());
    }

    private void minecraftHeadsExecute(ButtonComponent button) {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://minecraft-heads.com", (boolean)true);
    }

    private class_2561 getTagButtonText() {
        return class_2561.method_43469((String)TAG_BUTTON_TEXT, (Object[])new Object[]{this.selectedTags.size()});
    }

    private class_2561 getTagLabelText() {
        return class_2561.method_43469((String)TAG_LABEL_TEXT, (Object[])new Object[]{this.selectedTags.size(), this.availableTags.size(), this.categoryHeadsWithFilter.size()});
    }

    private class_2561 getSelectedTagText(String value) {
        return class_2561.method_43470((String)value).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_36139(4439218));
    }

    private void updatePreview(class_1799 stack) {
        Optional<class_8685> skinTexturesOptional = HeadUtils.getSkinTextures(stack);
        class_9296 profileComponent = (class_9296)stack.method_58694(class_9334.field_49617);
        if (skinTexturesOptional.isPresent() || profileComponent == null) {
            this.updatePreview(skinTexturesOptional.orElse(class_1068.method_62620()));
            return;
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1582().method_52863(profileComponent.comp_2413()).whenComplete((skinTextures, throwable) -> {
            if (throwable == null && skinTextures.isPresent()) {
                this.updatePreview((class_8685)skinTextures.get());
            }
        });
    }

    private void updatePreview(class_8685 textures) {
        this.frontEntityPreview.skin(textures);
        this.backEntityPreview.skin(textures);
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.selectedCategory);
        output.writeObject(this.contentSearchField.method_1882());
        output.writeBoolean(this.styleCheckbox.method_20372());
        output.writeObject(this.selectedTags);
        output.writeInt(this.page);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.selectedCategory = (String)input.readObject();
        this.contentSearchField.text((String)input.readObject());
        this.styleCheckbox.checked(input.readBoolean());
        if (this.selectedCategory == null) {
            return;
        }
        ArrayList<Component> categoryList = new ArrayList<Component>(this.categoryButtonList);
        categoryList.removeIf(component -> !this.selectedCategory.equals(component.id()));
        categoryList.stream().findAny().ifPresent(component -> this.categoryButtonExecute((ButtonComponent)component, this.selectedCategory, () -> {
            try {
                this.selectedTags = (Set)input.readObject();
                this.tagButton.method_25355(this.getTagButtonText());
                this.applyFilters();
                this.setPage(input.readInt());
            }
            catch (IOException | ClassNotFoundException e) {
                FzmmClient.LOGGER.error("[HeadGalleryScreen] Failed to restore category", (Throwable)e);
            }
        }));
    }
}

