/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.EBooleanButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.tabs.TabContainer;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.algorithms.ImagetextBrailleAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.algorithms.ImagetextCharactersAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTooltip;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextBookPageTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextBookTooltipTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextCopyTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextHologramTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextLoreTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextSignTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.ImagetextTextDisplayTab;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ImagetextScreen
extends BaseFzmmScreen
implements IMemento {
    private static final double DEFAULT_SIZE_VALUE = 32.0;
    public static final double MAX_SIMILARITY_THRESHOLD = 10.0;
    private static final long PREVIEW_UPDATE_DELAY_MILLIS = 20L;
    private final ImagetextLogic imagetextLogic;
    private ImageRowsElements imageElements;
    private EBooleanButton preserveImageAspectRatioToggle;
    private SmallCheckboxComponent showResolutionCheckbox;
    private SmallCheckboxComponent smoothImageCheckbox;
    private SliderWidget widthSlider;
    private SliderWidget heightSlider;
    private SliderWidget similarityThreshold;
    private EFlowLayout previewLayout;
    private Animation.Composed smallGuiAnimation;
    private CompletableFuture<Void> scheduledUpdatePreview = CompletableFuture.completedFuture(null);
    private TabContainer algorithmTabContainer;
    private TabContainer modeTabContainer;

    public ImagetextScreen(@Nullable class_437 parent) {
        super("imagetext", "imagetext", parent);
        this.imagetextLogic = new ImagetextLogic();
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        FzmmConfig.Imagetext config = FzmmClient.CONFIG.imagetext;
        ImageRows imageRows = new ImageRows(this.getBaseScreenTranslationKey(), "image", "imageSourceType", true);
        this.imageElements = ImageRows.setup(imageRows, "image", "imageSourceType", ImageMode.URL);
        FlowLayout imageTextBoxLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "image-textbox");
        imageTextBoxLayout.child(this.imageElements.valueField().sizing(Sizing.expand((int)100), Sizing.fixed((int)16)));
        FlowLayout imageButtonLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "image-buttons");
        ArrayList<Object> imageButtonList = new ArrayList<Object>();
        for (ImageMode value2 : ImageMode.values()) {
            ButtonComponent buttonComponent2 = this.imageElements.imageModeButtons().get((Object)value2);
            buttonComponent2.sizing(Sizing.fixed((int)16));
            imageButtonList.add(buttonComponent2);
        }
        imageButtonList.add(Components.spacer().verticalSizing(Sizing.fixed((int)1)));
        imageButtonList.add(this.imageElements.imageButton().verticalSizing(Sizing.fixed((int)16)).margins(Insets.none()));
        ImageButtonComponent imageButton = this.imageElements.imageButton();
        this.preserveImageAspectRatioToggle = rootComponent.childByIdOrThrow(EBooleanButton.class, "preserveImageAspectRatio");
        this.preserveImageAspectRatioToggle.enabled(config.defaultPreserveImageAspectRatio());
        this.showResolutionCheckbox = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "showResolution");
        this.showResolutionCheckbox.checked(false);
        this.smoothImageCheckbox = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "smoothImage");
        this.smoothImageCheckbox.checked(true);
        this.widthSlider = SliderRow.setup(rootComponent, "width", 32.0, 2.0, config.maxResolution(), Integer.class, 0, 3.0, aDouble -> this.onResolutionChanged(this.widthSlider, this.heightSlider, true));
        this.heightSlider = SliderRow.setup(rootComponent, "height", 32.0, 2.0, config.maxResolution(), Integer.class, 0, 3.0, aDouble -> this.onResolutionChanged(this.heightSlider, this.widthSlider, false));
        this.similarityThreshold = SliderRow.setup(rootComponent, "similarityThreshold", config.defaultSimilarityThreshold(), 0.0, 10.0, Double.class, 1, 0.1, null);
        this.similarityThreshold.message(s -> class_2561.method_43470((String)(s + "%")));
        imageButtonLayout.children(imageButtonList);
        List<ImagetextBrailleAlgorithm> algorithmTabs = List.of(new ImagetextCharactersAlgorithm(), new ImagetextBrailleAlgorithm());
        ContextMenuButton algorithmButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "algorithm-button");
        this.algorithmTabContainer = rootComponent.childByIdOrThrow(TabContainer.class, "algorithm-tabs");
        this.algorithmTabContainer.addParsedTabs(algorithmTabs).onSelect(tab -> {
            algorithmButton.method_25355(this.getAlgorithmText());
            this.scheduleUpdatePreview();
        });
        algorithmButton.setContextMenuOptions(contextMenu -> {
            for (IImagetextAlgorithm algorithm : algorithmTabs) {
                contextMenu.button(algorithm.getButtonText(), dropdown -> {
                    algorithmButton.removeContextMenu();
                    algorithm.clearCache();
                    this.algorithmTabContainer.selectTab(algorithm);
                    this.scheduleUpdatePreview();
                    this.onResolutionChanged(this.widthSlider, this.heightSlider, true);
                });
            }
        });
        for (IImagetextAlgorithm iImagetextAlgorithm : algorithmTabs) {
            iImagetextAlgorithm.setupComponents(rootComponent);
        }
        this.algorithmTabContainer.selectTab();
        List<ImagetextCopyTab> modeTabs = List.of(new ImagetextLoreTab(), new ImagetextBookPageTab(), new ImagetextBookTooltipTab(), new ImagetextTextDisplayTab(), new ImagetextSignTab(), new ImagetextHologramTab(), new ImagetextCopyTab());
        ContextMenuButton contextMenuButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "mode-button");
        this.modeTabContainer = rootComponent.childByIdOrThrow(TabContainer.class, "mode-tabs");
        this.modeTabContainer.addParsedTabs(modeTabs).onSelect(tab -> {
            contextMenuButton.method_25355(this.getModeText());
            this.scheduleUpdatePreview();
        });
        contextMenuButton.setContextMenuOptions(contextMenu -> {
            for (IImagetextTab mode : modeTabs) {
                contextMenu.button(mode.getButtonText(), dropdown -> {
                    contextMenuButton.removeContextMenu();
                    this.modeTabContainer.selectTab(mode);
                });
            }
        });
        for (IImagetextTab iImagetextTab : modeTabs) {
            iImagetextTab.setupComponents(rootComponent);
        }
        this.modeTabContainer.selectTab();
        this.previewLayout = rootComponent.childByIdOrThrow(EFlowLayout.class, "preview-layout");
        this.widthSlider.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.heightSlider.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.similarityThreshold.onChanged().subscribe(value -> this.scheduleUpdatePreview());
        this.showResolutionCheckbox.onChanged().subscribe(buttonComponent -> this.scheduleUpdatePreview());
        this.smoothImageCheckbox.onChanged().subscribe(buttonComponent -> {
            ((IImagetextAlgorithm)this.algorithmTabContainer.selectedTab()).clearCache();
            this.scheduleUpdatePreview();
        });
        for (IImagetextAlgorithm iImagetextAlgorithm : algorithmTabs) {
            iImagetextAlgorithm.setUpdatePreviewCallback(this::scheduleUpdatePreview);
        }
        ButtonComponent executeButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "execute-button");
        executeButton.active(false);
        executeButton.onPress(button -> this.execute());
        imageButton.setButtonCallback(image -> {
            executeButton.field_22763 = image.isPresent();
            if (image.isPresent()) {
                ((IImagetextAlgorithm)this.algorithmTabContainer.selectedTab()).clearCache();
                this.scheduleUpdatePreview();
                this.updateAspectRatio((BufferedImage)image.get());
            }
        });
        FlowLayout flowLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "image-options-layout");
        FlowLayout algorithmOptionsLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "algorithm-options-layout");
        FlowLayout imageModeLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "image-mode-layout");
        Animation imageLayoutAnimation = flowLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        Animation algorithmLayoutAnimationHorizontal = algorithmOptionsLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        Animation algorithmLayoutAnimationVertical = algorithmOptionsLayout.verticalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.content());
        Animation imageModeFixAnimation = imageModeLayout.horizontalSizing().animate(100, Easing.LINEAR, (Animatable)Sizing.expand((int)100));
        this.smallGuiAnimation = Animation.compose((Animation[])new Animation[]{imageLayoutAnimation, algorithmLayoutAnimationHorizontal, algorithmLayoutAnimationVertical, imageModeFixAnimation});
        ScrollContainer leftOptionsScroll = rootComponent.childByIdOrThrow(ScrollContainer.class, "left-options-scroll");
        ButtonComponent expandPreviewButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "expand-preview-button");
        Animation leftOptionsAnimation = leftOptionsScroll.horizontalSizing().animate(100, Easing.CUBIC, (Animatable)Sizing.expand((int)0));
        AtomicBoolean isExpanded = new AtomicBoolean(false);
        expandPreviewButton.onPress(buttonComponent -> {
            if (isExpanded.getAndSet(!isExpanded.get())) {
                leftOptionsAnimation.reverse();
                expandPreviewButton.method_25355((class_2561)class_2561.method_43471((String)"fzmm.gui.button.arrow2.left"));
            } else {
                leftOptionsAnimation.forwards();
                expandPreviewButton.method_25355((class_2561)class_2561.method_43471((String)"fzmm.gui.button.arrow2.right"));
            }
        });
        this.setSmallGuiAnimation(this.field_22789);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.imageElements.valueField(), Component.FocusSource.MOUSE_CLICK);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.setSmallGuiAnimation(width);
    }

    private boolean isSmallGuiDesign(int width) {
        return (float)width * 0.3f < 200.0f;
    }

    private void setSmallGuiAnimation(int width) {
        if (this.isSmallGuiDesign(width)) {
            this.smallGuiAnimation.forwards();
        } else {
            this.smallGuiAnimation.backwards();
        }
    }

    private class_2561 getAlgorithmText() {
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.algorithm", (Object[])new Object[]{this.algorithmTabContainer.selectedTab().getButtonText()});
    }

    private class_2561 getModeText() {
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.mode", (Object[])new Object[]{this.modeTabContainer.selectedTab().getButtonText()});
    }

    private void onResolutionChanged(SliderWidget config, SliderWidget configToChange, boolean isWidth) {
        float algorithmAspectRatio;
        int valueToChange;
        int value;
        if (!this.imageElements.imageButton().hasImage() || !this.preserveImageAspectRatioToggle.enabled()) {
            return;
        }
        Optional<BufferedImage> imageOptional = this.imageElements.imageButton().getImage();
        if (imageOptional.isEmpty()) {
            return;
        }
        BufferedImage image = imageOptional.get();
        int width = image.getWidth();
        int height = image.getHeight();
        IImagetextAlgorithm algorithm = (IImagetextAlgorithm)this.algorithmTabContainer.selectedTab();
        if (isWidth) {
            value = width;
            valueToChange = height;
            algorithmAspectRatio = algorithm.widthRatio();
        } else {
            value = height;
            valueToChange = width;
            algorithmAspectRatio = algorithm.heightRatio();
        }
        this.preserveAspectRatio(config, configToChange, value, valueToChange, algorithmAspectRatio);
    }

    private void preserveAspectRatio(SliderWidget config, SliderWidget configToChange, int value, int valueToChange, float algorithmAspectRatio) {
        valueToChange = (int)((float)valueToChange * algorithmAspectRatio);
        int configValue = (Integer)config.parsedValue();
        int newValue = ImagetextLogic.getResizedAspectRatio(value, valueToChange, configValue);
        newValue = (int)Math.clamp((double)newValue, configToChange.min(), configToChange.max());
        configToChange.setDiscreteValueWithoutCallback(newValue);
    }

    public void execute() {
        CompletableFuture.runAsync(() -> {
            Optional<BufferedImage> image = this.imageElements.imageButton().getImage();
            if (image.isEmpty()) {
                return;
            }
            this.buildImagetext(image.get(), true);
            ((IImagetextTab)this.modeTabContainer.selectedTab()).execute(this.imagetextLogic);
        }).handle((unused, throwable) -> {
            if (throwable != null) {
                FzmmClient.LOGGER.error("[ImagetextScreen] Error in imagetext give", throwable);
                class_310.method_1551().execute(() -> SnackBarManager.getInstance().add(BaseSnackBarComponent.builder("imagetext").title((class_2561)class_2561.method_43470((String)"fzmm.giveItem.error")).backgroundColor(EStyles.ALERT_ERROR_COLOR).closeButton().build()));
            }
            return null;
        });
    }

    public void scheduleUpdatePreview() {
        if (this.scheduledUpdatePreview != null && !this.scheduledUpdatePreview.isDone()) {
            return;
        }
        this.scheduledUpdatePreview = CompletableFuture.runAsync(() -> this.updatePreview(false), CompletableFuture.delayedExecutor(20L, TimeUnit.MILLISECONDS));
        this.scheduledUpdatePreview.handle((unused, throwable) -> {
            if (throwable != null) {
                FzmmClient.LOGGER.error("[ImagetextScreen] Error updating preview", throwable);
            }
            return null;
        });
    }

    public void updatePreview(boolean isExecute) {
        Optional<BufferedImage> image = this.imageElements.imageButton().getImage();
        if (image.isEmpty()) {
            return;
        }
        this.buildImagetext(image.get(), isExecute);
        List<class_2561> imagetext = this.imagetextLogic.text();
        class_5250 tooltipText = class_2561.method_43473().method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        tooltipText.method_10852((class_2561)class_2561.method_43469((String)"fzmm.gui.imagetext.label.textLength", (Object[])new Object[]{this.imagetextLogic.textLength()}));
        Object t = this.modeTabContainer.selectedTab();
        if (t instanceof IImagetextTooltip) {
            IImagetextTooltip metadata = (IImagetextTooltip)t;
            tooltipText.method_27693("\n");
            tooltipText.method_10852(metadata.getTooltip(this.imagetextLogic));
        }
        assert (this.field_22787 != null);
        this.field_22787.execute(() -> this.previewLayout.configure(layout -> {
            layout.clearChildren();
            layout.children(imagetext.stream().map(EComponents::label).toList());
            layout.tooltip((class_2561)tooltipText);
        }));
    }

    private void buildImagetext(BufferedImage image, boolean isExecute) {
        int width = (Integer)this.widthSlider.parsedValue();
        int height = (Integer)this.heightSlider.parsedValue();
        boolean smoothScaling = this.smoothImageCheckbox.checked();
        boolean showResolution = this.showResolutionCheckbox.checked();
        double similarityThreshold = (Double)this.similarityThreshold.parsedValue();
        IImagetextAlgorithm algorithm = (IImagetextAlgorithm)this.algorithmTabContainer.selectedTab();
        ImagetextData data = new ImagetextData(image, width, height, smoothScaling, similarityThreshold);
        ((IImagetextTab)this.modeTabContainer.selectedTab()).build(algorithm, this.imagetextLogic, data, isExecute);
        if (showResolution) {
            this.imagetextLogic.addResolution();
        }
    }

    private void updateAspectRatio(BufferedImage image) {
        if (!this.preserveImageAspectRatioToggle.enabled()) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (height > width) {
            this.onResolutionChanged(this.heightSlider, this.widthSlider, false);
        } else {
            this.onResolutionChanged(this.widthSlider, this.heightSlider, true);
        }
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.imageElements.valueField().method_1882());
        output.writeObject((Object)this.imageElements.mode().get());
        output.writeInt((Integer)this.widthSlider.parsedValue());
        output.writeInt((Integer)this.heightSlider.parsedValue());
        output.writeBoolean(this.smoothImageCheckbox.checked());
        output.writeBoolean(this.showResolutionCheckbox.checked());
        output.writeBoolean(this.preserveImageAspectRatioToggle.enabled());
        output.writeDouble((Double)this.similarityThreshold.parsedValue());
        this.modeTabContainer.backup(output);
        this.algorithmTabContainer.backup(output);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.imageElements.valueField().text((String)input.readObject());
        this.imageElements.imageModeButtons().get((Object)((ImageMode)((Object)input.readObject()))).method_25306();
        this.widthSlider.setFromDiscreteValue(input.readInt());
        this.heightSlider.setFromDiscreteValue(input.readInt());
        this.smoothImageCheckbox.checked(input.readBoolean());
        this.showResolutionCheckbox.checked(input.readBoolean());
        this.preserveImageAspectRatioToggle.enabled(input.readBoolean());
        this.similarityThreshold.setFromDiscreteValue(input.readDouble());
        this.modeTabContainer.restore(input);
        this.algorithmTabContainer.restore(input);
    }
}

