/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.SpawnEggBuilder;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.core.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_8113;
import net.minecraft.class_8824;

public class ImagetextTextDisplayTab
implements IImagetextTab,
IMemento {
    private static final String TEXT_DISPLAY_TAG = "ImagetextTextDisplay";
    private SliderWidget textOpacity;
    private ConfigTextBox backgroundColor;
    private SmallCheckboxComponent textShadow;
    private SmallCheckboxComponent textSeeThrough;
    private ContextMenuButton textAlignmentButton;
    private class_8113.class_8123.class_8124 textAlignment;
    private ContextMenuButton billboardButton;
    private class_8113.class_8114 billboard;
    private SliderWidget rotation;

    @Override
    public void build(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.buildImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        class_2487 textDisplayNbt = new class_2487();
        int width = logic.isEmpty() ? 1 : class_310.method_1551().field_1772.method_27525((class_5348)logic.text().get(0));
        textDisplayNbt.method_67494("text", class_8824.field_46597, (Object)logic.mergeText());
        textDisplayNbt.method_10569("line_width", width);
        textDisplayNbt.method_10569("text_opacity", (int)this.textOpacity.discreteValue());
        textDisplayNbt.method_10569("background", ((Color)this.backgroundColor.parsedValue()).argb());
        textDisplayNbt.method_10556("shadow", this.textShadow.checked());
        textDisplayNbt.method_10556("see_through", this.textSeeThrough.checked());
        textDisplayNbt.method_10582("alignment", this.textAlignment.method_15434());
        textDisplayNbt.method_10582("billboard", this.billboard.method_15434());
        class_2499 rotationList = new class_2499();
        rotationList.add((Object)class_2494.method_23244((float)((float)this.rotation.discreteValue())));
        rotationList.add((Object)class_2494.method_23244((float)0.0f));
        textDisplayNbt.method_10566("Rotation", (class_2520)rotationList);
        class_2499 tagList = new class_2499();
        tagList.add((Object)class_2519.method_23256((String)TEXT_DISPLAY_TAG));
        textDisplayNbt.method_10566("Tags", (class_2520)tagList);
        class_1799 spawnEgg = SpawnEggBuilder.builder().entityType(class_1299.field_42457).entityTag(textDisplayNbt).get();
        ItemUtils.give(spawnEgg);
        InvisibleEntityWarning.add(false, false, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.textDisplay"), TEXT_DISPLAY_TAG);
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        assert (class_310.method_1551().field_1724 != null);
        this.textOpacity = SliderRow.setup(rootComponent, "textDisplayTextOpacity", 255.0, 0.0, 255.0, Integer.class, 0, 10.0, null);
        this.backgroundColor = ColorRow.setup(rootComponent, "textDisplayBackgroundColor", Color.ofArgb((int)0x40000000), true, null);
        this.textShadow = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "textDisplayTextShadow-checkbox");
        this.textShadow.checked(false);
        this.textSeeThrough = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "textDisplayTextSeeThrough-checkbox");
        this.textSeeThrough.checked(false);
        this.textAlignmentButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "textDisplayTextAlignment");
        this.textAlignmentButton.setContextMenuOptions(dropdownComponent -> {
            for (class_8113.class_8123.class_8124 option : class_8113.class_8123.class_8124.values()) {
                dropdownComponent.button(this.getTextAlignmentMessage(option), dropdownButton -> {
                    this.updateTextAlignment(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateTextAlignment(class_8113.class_8123.class_8124.field_42451);
        this.billboardButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "textDisplayBillboard");
        this.billboardButton.setContextMenuOptions(dropdownComponent -> {
            for (class_8113.class_8114 option : class_8113.class_8114.values()) {
                dropdownComponent.button(this.getBillboardMessage(option), dropdownButton -> {
                    this.updateBillboard(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBillboard(class_8113.class_8114.field_42406);
        this.rotation = SliderRow.setup(rootComponent, "textDisplayRotation", class_3532.method_15393((float)class_310.method_1551().field_1724.method_36454()), -180.0, 180.0, Float.class, 1, 30.0, null);
    }

    private void updateTextAlignment(class_8113.class_8123.class_8124 value) {
        this.textAlignment = value;
        this.textAlignmentButton.method_25355(this.getTextAlignmentMessage(this.textAlignment));
    }

    public class_2561 getTextAlignmentMessage(class_8113.class_8123.class_8124 value) {
        return class_2561.method_43471((String)("fzmm.gui.option.text_alignment." + value.method_15434()));
    }

    public void updateBillboard(class_8113.class_8114 value) {
        this.billboard = value;
        this.billboardButton.method_25355(this.getBillboardMessage(this.billboard));
    }

    public class_2561 getBillboardMessage(class_8113.class_8114 value) {
        return class_2561.method_43471((String)("fzmm.gui.option.billboard." + value.method_15434()));
    }

    @Override
    public String getId() {
        return "textDisplay";
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeInt((int)this.textOpacity.discreteValue());
        output.writeObject(this.backgroundColor.method_1882());
        output.writeBoolean(this.textShadow.checked());
        output.writeBoolean(this.textSeeThrough.checked());
        output.writeObject(this.textAlignment);
        output.writeObject(this.billboard);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.textOpacity.setFromDiscreteValue(input.readInt());
        this.backgroundColor.text((String)input.readObject());
        this.textShadow.checked(input.readBoolean());
        this.textSeeThrough.checked(input.readBoolean());
        this.updateTextAlignment((class_8113.class_8123.class_8124)input.readObject());
        this.updateBillboard((class_8113.class_8114)input.readObject());
    }
}

