/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.player_statue;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.tabs.ITab;
import fzmm.zailer.me.client.gui.components.tabs.TabContainer;
import fzmm.zailer.me.client.gui.options.HorizontalDirectionOption;
import fzmm.zailer.me.client.gui.player_statue.tabs.IPlayerStatueTab;
import fzmm.zailer.me.client.gui.player_statue.tabs.PlayerStatueGenerateTab;
import fzmm.zailer.me.client.gui.player_statue.tabs.PlayerStatueUpdateTab;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.logic.history.IMemento;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class PlayerStatueScreen
extends BaseFzmmScreen
implements IMemento {
    public static final String EXECUTE_ID = "execute-button";
    private HorizontalDirectionOption direction;
    private ConfigTextBox posX;
    private ConfigTextBox posY;
    private ConfigTextBox posZ;
    private TextBoxComponent nameField;
    private TabContainer tabContainer;

    public PlayerStatueScreen(@Nullable class_437 parent) {
        super("player_statue", "playerStatue", parent);
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        rootComponent.childByIdOrThrow(ButtonComponent.class, "faq-button").onPress(this::faqExecute);
        ButtonComponent executeButton = rootComponent.childByIdOrThrow(ButtonComponent.class, EXECUTE_ID).onPress(this::execute);
        rootComponent.childByIdOrThrow(ButtonComponent.class, "difficult-to-remove-entity-button").onPress(buttonComponent -> InvisibleEntityWarning.addOverlay(true, true, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.playerStatue"), "PlayerStatue"));
        ContextMenuButton directionButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "horizontal-direction-context-menu-option");
        directionButton.setContextMenuOptions(dropdownComponent -> {
            for (HorizontalDirectionOption option : HorizontalDirectionOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.direction = option;
                    directionButton.method_25355((class_2561)class_2561.method_43471((String)option.getTranslationKey()));
                    dropdownButton.remove();
                });
            }
        });
        this.direction = HorizontalDirectionOption.getPlayerHorizontalDirection();
        directionButton.method_25355((class_2561)class_2561.method_43471((String)this.direction.getTranslationKey()));
        this.posX = NumberRow.setup(rootComponent, "posX", player.method_31477(), Float.class);
        this.posY = NumberRow.setup(rootComponent, "posY", player.method_23318(), Float.class);
        this.posZ = NumberRow.setup(rootComponent, "posZ", player.method_31479(), Float.class);
        this.nameField = TextBoxRow.setup(rootComponent, "name", "", 65535);
        this.tabContainer = rootComponent.childByIdOrThrow(TabContainer.class, "tabs");
        List<PlayerStatueUpdateTab> tabs = List.of(new PlayerStatueGenerateTab(), new PlayerStatueUpdateTab());
        this.tabContainer.addParsedTabs(tabs).onSelect(tab -> executeButton.active(((IPlayerStatueTab)tab).canExecute())).setupTabs(rootComponent, ((ITab)tabs.get(0)).getId()).selectTab();
    }

    private void faqExecute(class_4185 buttonWidget) {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://github.com/Zailer43/FZMM-Mod/blob/1.21.7/dev/docs/en/wiki/player_statue/0.2.9_player_statue.md", (boolean)true);
    }

    private void execute(class_4185 buttonWidget) {
        float x = ((Float)this.posX.parsedValue()).floatValue();
        float y = ((Float)this.posY.parsedValue()).floatValue();
        float z = ((Float)this.posZ.parsedValue()).floatValue();
        String name = this.nameField.method_1882();
        ((IPlayerStatueTab)this.tabContainer.selectedTab()).execute(this.direction, x, y, z, name);
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.nameField.method_1882());
        this.tabContainer.backup(output);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.nameField.text((String)input.readObject());
        this.tabContainer.restore(input);
    }
}

