/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format.tabs;

import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.text_format.tabs.ITextFormatTab;
import fzmm.zailer.me.client.logic.TextFormatLogic;
import fzmm.zailer.me.compat.CompatMods;
import fzmm.zailer.me.compat.placeholder_api.PlaceholderApiCompat;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;

public class TextFormatPlaceholderApiTab
implements ITextFormatTab {
    private static final String PLACEHOLDER_WIKI = "https://placeholders.pb4.eu/user/text-format";
    private FlowLayout infoLayout;

    @Override
    public String getId() {
        return "placeholder_api";
    }

    @Override
    public class_2561 getText(TextFormatLogic logic) {
        String message = logic.message();
        return CompatMods.PLACEHOLDER_API_PRESENT ? PlaceholderApiCompat.parse(message) : class_2561.method_43470((String)message);
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.infoLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "placeholder-info");
        ButtonComponent wikiInfo = Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.textFormat.button.placeholderApiWiki"), buttonComponent -> {
            class_310 client = class_310.method_1551();
            class_407.method_60866((class_437)client.field_1755, (String)PLACEHOLDER_WIKI, (boolean)true);
        });
        this.infoLayout.child((Component)wikiInfo);
        this.addUsageExamples();
    }

    private void addUsageExamples() {
        ArrayList<Object> examples = new ArrayList<Object>();
        ArrayList<ELabelComponent> componentList = new ArrayList<ELabelComponent>();
        examples.add("<yellow>Yellow, <aqua>aqua, <light_purple>and light purple message");
        examples.add("<color #AA0060>Custom</color> <color #80D000>colors</color> <color #00C0C0>message</color>");
        examples.add("<strikethrough>strikethrough</strikethrough> <underline>underline</underline>");
        examples.add("<italic>italic</italic> <bold>bold</bold> <obfuscated>obfuscated</obfuscated>");
        examples.add("<st>strikethrough <underlined>underline <i>italic <b>bold <obf>obfuscated");
        examples.add("<font default>Default minecraft font, <font uniform>uniform font, <font alt>alt font");
        examples.add("<green><underline><lang '" + class_1802.field_8361.method_7876() + "'></underline></green>");
        examples.add("<gr #306ACF #4530CF #30BACF><b>gradient message</b></gr>");
        examples.add("<hgr #306ACF #4530CF #30BACF><b>hard gradient message</b></hgr>");
        examples.add("<rainbow>Rainbow message</rainbow>");
        examples.add("<rb 0.8 0.7 0>parameters of rainbow are: frequency, saturation, offset</rb>");
        examples.add("<red><b><underline>Hello</></> world");
        componentList.add(EComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.textFormat.label.placeholderApi.examples")));
        for (String string : examples) {
            componentList.add((ELabelComponent)EComponents.label(PlaceholderApiCompat.parse(string)).tooltip((class_2561)class_2561.method_43470((String)string)));
        }
        ((Component)componentList.get(componentList.size() - 1)).margins(Insets.bottom((int)6));
        this.infoLayout.children(componentList);
    }

    @Override
    public void setRandomValues() {
    }

    @Override
    public void componentsCallback(Consumer<Object> callback) {
    }

    @Override
    public boolean hasStyles() {
        return false;
    }
}

