/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.history;

import fzmm.zailer.me.client.FzmmClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public interface IMemento {
    default public byte[] backup() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(baos);
            this.backup(output);
            output.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[IMemento] Failed to backup", (Throwable)e);
            return new byte[0];
        }
    }

    public void backup(ObjectOutputStream var1) throws IOException;

    default public void restore(byte[] state) {
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(state));
            this.restore(input);
            input.close();
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[IMemento] Failed to restore", (Throwable)e);
        }
    }

    public void restore(ObjectInputStream var1) throws IOException, ClassNotFoundException;
}

