/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLine;
import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ImagetextLogic {
    private List<class_2561> imagetext = new ArrayList<class_2561>();
    private long textLength = 0L;
    private int width = 0;
    private int height = 0;

    public void buildImagetext(IImagetextAlgorithm algorithm, ImagetextData data) {
        this.width = data.width();
        this.height = data.height();
        this.textLength = 0L;
        this.imagetext = this.build(algorithm, data);
    }

    public List<class_2561> build(IImagetextAlgorithm algorithm, ImagetextData data) {
        algorithm.tryUpdateCache(data);
        algorithm.build();
        ArrayList<class_2561> result = new ArrayList<class_2561>(data.height());
        ImagetextLine line = new ImagetextLine(data.similarityThreshold());
        for (int y = 0; y != data.height(); ++y) {
            line.characters(algorithm.linePixels(y));
            for (int x = 0; x != data.width(); ++x) {
                line.add(algorithm.colorAt(x, y));
            }
            result.add(line.build());
            this.textLength += line.textLength();
            line.reset();
        }
        return result;
    }

    public static int getResizedAspectRatio(int value, int changeValue, int referenceValue) {
        return (int)((double)changeValue / (double)value * (double)referenceValue);
    }

    public void addResolution() {
        String message = class_2561.method_43469((String)"fzmm.item.imagetext.resolution", (Object[])new Object[]{this.width, this.height}).getString();
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        class_5250 text = class_2561.method_43471((String)message).method_10862(class_2583.field_24360.method_36139(color));
        this.imagetext.add((class_2561)FzmmUtils.disableItalicConfig(text, true));
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public List<class_2561> text() {
        return this.imagetext;
    }

    public long textLength() {
        return this.textLength;
    }

    public class_2561 mergeText() {
        class_5250 result = class_2561.method_43473();
        List<class_2561> imagetext = this.text();
        int size = imagetext.size();
        for (int i = 0; i != size; ++i) {
            result.method_10852(imagetext.get(i));
            if (i == size - 1) continue;
            result.method_27693("\n");
        }
        return result;
    }

    public boolean isEmpty() {
        return this.imagetext.isEmpty();
    }
}

