/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.player_statue.statue_head_skin;

import fzmm.zailer.me.utils.position.PosI;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public record HeadFace(int x, int y) {
    private static final short HEAD_SIZE = 8;
    private static final short HAT_LAYER_X_DISTANCE = 32;

    public void draw(Graphics2D graphics, BufferedImage playerSkin, PosI source, boolean hatLayer, int scale) {
        int source2Distance = 4 * scale;
        int sourceX = (Integer)source.getX() * scale;
        int sourceY = (Integer)source.getY() * scale;
        int destinationX = this.x;
        if (hatLayer) {
            destinationX += 32;
        }
        graphics.drawImage(playerSkin, destinationX, this.y, destinationX + 8, this.y + 8, sourceX, sourceY, sourceX + source2Distance, sourceY + source2Distance, null);
    }

    public static enum HEAD_FACE {
        RIGHT_FACE(16, 8),
        LEFT_FACE(0, 8),
        FRONT_FACE(8, 8),
        BACK_FACE(24, 8),
        UP_FACE(8, 0),
        BOTTOM_FACE(16, 0);

        private final int x;
        private final int y;

        private HEAD_FACE(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public HeadFace get() {
            return new HeadFace(this.x, this.y);
        }
    }
}

