/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class BookBuilder {
    private boolean resolved = false;
    private final List<class_9262<class_2561>> pages = new ArrayList<class_9262<class_2561>>();
    private int generation = 0;
    private String author;
    private class_9262<String> title;

    private BookBuilder() {
        assert (class_310.method_1551().field_1724 != null);
        this.author = class_310.method_1551().field_1724.method_5477().getString();
        this.title = null;
    }

    public static BookBuilder builder() {
        return new BookBuilder();
    }

    public static Optional<BookBuilder> of(class_1799 bookStack) {
        class_9302 content = (class_9302)(bookStack = bookStack.method_7972()).method_58694(class_9334.field_49606);
        if (content == null) {
            return Optional.empty();
        }
        return Optional.of(BookBuilder.builder().title((class_9262<String>)content.comp_2419()).author(content.comp_2420()).resolved(content.comp_2423()).generation(content.comp_2421()).addFilteredPages(content.comp_2422()));
    }

    public BookBuilder addPage(class_2561 text) {
        this.pages.add((class_9262<class_2561>)class_9262.method_57137((Object)text));
        return this;
    }

    public BookBuilder addFilteredPages(List<class_9262<class_2561>> pages) {
        this.pages.addAll(pages);
        return this;
    }

    public BookBuilder title(String title) {
        return this.title((class_9262<String>)class_9262.method_57137((Object)title));
    }

    public BookBuilder title(class_9262<String> filteredTitle) {
        this.title = filteredTitle;
        return this;
    }

    public BookBuilder author(String author) {
        this.author = author;
        return this;
    }

    public BookBuilder resolved(boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    public BookBuilder generation(int generation) {
        this.generation = generation;
        return this;
    }

    public int exceedsSerializedLengthLimit() {
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        for (class_9262<class_2561> pageFilteredPair : this.pages) {
            class_2561 pageText = (class_2561)pageFilteredPair.comp_2369();
            if (pageText == null || !class_9302.method_57524((class_2561)pageText, (class_7225.class_7874)registryManager)) continue;
            return class_2561.class_2562.method_10867((class_2561)pageText, (class_7225.class_7874)registryManager).length();
        }
        return -1;
    }

    public class_1799 get() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        stack.method_57368(class_9334.field_49606, (Object)class_9302.field_49829, component -> {
            class_9262 titleCopy = this.title;
            if (((String)titleCopy.method_57140(false)).length() > 32) {
                titleCopy = class_9262.method_57137((Object)((String)titleCopy.method_57140(false)).substring(0, 32));
            }
            return new class_9302(titleCopy, this.author, this.generation, this.pages, this.resolved);
        });
        return stack;
    }
}

