/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image.source;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.image.ScreenshotZoneComponent;
import fzmm.zailer.me.client.gui.components.image.source.IInteractiveImageLoader;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.hud.Hud;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;

public class ScreenshotSource
implements IInteractiveImageLoader {
    private static final class_2960 HUD_CAPTURE_SCREENSHOT = class_2960.method_60655((String)"fzmm", (String)"screenshot_capture");
    private static ScreenshotSource instance;
    private BufferedImage image = null;
    private Consumer<BufferedImage> consumer;
    private BaseFzmmScreen previousScreen;

    public static ScreenshotSource getInstance() {
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    @Override
    public void execute(Consumer<BufferedImage> consumer) {
        BaseFzmmScreen baseScreen;
        this.image = null;
        this.consumer = consumer;
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        this.previousScreen = class_4372 instanceof BaseFzmmScreen ? (baseScreen = (BaseFzmmScreen)class_4372) : null;
        SnackBarManager.getInstance().moveToHud(this.previousScreen);
        client.method_1507(null);
        Hud.add((class_2960)HUD_CAPTURE_SCREENSHOT, this::getHud);
        instance = this;
    }

    @Override
    public Optional<BufferedImage> getImage() {
        return Optional.ofNullable(this.image);
    }

    @Override
    public boolean hasTextField() {
        return false;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.consumer.accept(this.image);
    }

    private FlowLayout getHud() {
        FlowLayout hudLayout = (FlowLayout)EContainers.verticalFlow(Sizing.fill((int)100), Sizing.fill((int)100)).positioning(Positioning.absolute((int)0, (int)0));
        ScreenshotZoneComponent screenshotZoneComponent = new ScreenshotZoneComponent();
        screenshotZoneComponent.sizing(Sizing.fill((int)100), Sizing.fill((int)100)).positioning(Positioning.absolute((int)0, (int)0));
        FlowLayout labelLayout = (FlowLayout)EContainers.verticalFlow(Sizing.fill((int)100), Sizing.fixed((int)25)).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).positioning(Positioning.absolute((int)0, (int)0));
        class_2561 keyTranslation = FzmmClient.OPEN_MAIN_GUI_KEYBINDING.method_16007();
        ELabelComponent labelComponent = EComponents.label((class_2561)class_2561.method_43469((String)"fzmm.gui.option.image.screenshot.message", (Object[])new Object[]{keyTranslation.getString()}));
        labelLayout.child((Component)labelComponent);
        hudLayout.child((Component)screenshotZoneComponent);
        hudLayout.child((Component)labelLayout);
        return hudLayout;
    }

    public void takeScreenshot() {
        class_276 framebuffer = class_310.method_1551().method_1522();
        try {
            class_318.method_1663((class_276)framebuffer, screenshot -> {
                screenshot.method_61942();
                this.processScreenshot(screenshot.method_61942());
            });
        }
        catch (Exception e) {
            this.complete(null, e);
        }
    }

    private void processScreenshot(int[] pixelArray) {
        CompletableFuture.supplyAsync(() -> {
            if (pixelArray == null) {
                return null;
            }
            class_1041 window = class_310.method_1551().method_22683();
            int width = window.method_4480();
            int height = window.method_4507();
            BufferedImage screenshot = new BufferedImage(width, height, 2);
            screenshot.getRaster().setDataElements(0, 0, width, height, pixelArray);
            int smallerSide = Math.min(width, height);
            int halfLongerSide = smallerSide / 2;
            BufferedImage scaled = screenshot.getSubimage(width / 2 - halfLongerSide, height / 2 - halfLongerSide, smallerSide, smallerSide);
            BufferedImage finalImage = this.removePadding(scaled);
            screenshot.flush();
            scaled.flush();
            return finalImage;
        }, (Executor)class_156.method_18349()).whenComplete(this::complete);
    }

    private void complete(BufferedImage image, Throwable throwable) {
        instance = null;
        ISnackBarComponent snackBar = null;
        if (throwable != null || image == null) {
            FzmmClient.LOGGER.error("[ScreenshotSource] Unexpected error while taking screenshot", throwable);
            snackBar = BaseSnackBarComponent.builder("load_image").title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.image.error.title")).details((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.image.error.details.unexpectedError")).backgroundColor(EStyles.ALERT_ERROR_COLOR).closeButton().build();
        }
        ISnackBarComponent finalSnackBar = snackBar;
        class_310.method_1551().execute(() -> {
            SnackBarManager manager = SnackBarManager.getInstance();
            Hud.remove((class_2960)HUD_CAPTURE_SCREENSHOT);
            if (finalSnackBar != null) {
                manager.add(finalSnackBar);
            }
            FzmmUtils.setScreen(this.previousScreen);
            this.previousScreen = null;
            this.setImage(image);
        });
    }

    private BufferedImage removePadding(BufferedImage image) {
        int padding = 25 * (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        BufferedImage paddedScreenshot = new BufferedImage(image.getWidth() - 2 * padding, image.getHeight() - 2 * padding, 1);
        Graphics2D g2d = paddedScreenshot.createGraphics();
        g2d.drawImage((Image)image, -padding, -padding, null);
        g2d.dispose();
        return paddedScreenshot;
    }
}

