/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.compat.symbol_chat.components.FontTextBoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextBoxRow
extends AbstractRow {
    public TextBoxRow(String baseTranslationKey, String id, String tooltipId, boolean symbolChatButtons) {
        super(baseTranslationKey, id, tooltipId, true);
        FontTextBoxComponent fontTextBoxComponent = (FontTextBoxComponent)this.childById(FontTextBoxComponent.class, TextBoxRow.getTextBoxId(id));
        if (fontTextBoxComponent != null) {
            fontTextBoxComponent.enableFontProcess(symbolChatButtons);
        }
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component textBox = new FontTextBoxComponent(Sizing.fixed((int)199)).id(TextBoxRow.getTextBoxId(id));
        return new Component[]{textBox};
    }

    public static String getTextBoxId(String id) {
        return id + "-text-box";
    }

    public static TextBoxComponent setup(EFlowLayout rootComponent, String id, String defaultValue, int maxLength) {
        return TextBoxRow.setup(rootComponent, id, defaultValue, maxLength, null);
    }

    public static TextBoxComponent setup(EFlowLayout rootComponent, String id, String defaultValue, int maxLength, @Nullable Consumer<String> changedListener) {
        TextBoxComponent textBox = rootComponent.childByIdOrThrow(TextBoxComponent.class, TextBoxRow.getTextBoxId(id));
        ButtonComponent resetButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, TextBoxRow.getResetButtonId(id));
        textBox.onChanged().subscribe(text -> {
            if (resetButton != null) {
                boolean bl = resetButton.field_22763 = !textBox.method_1882().equals(defaultValue);
            }
            if (changedListener != null) {
                changedListener.accept(text);
            }
        });
        textBox.method_1880(maxLength);
        textBox.text(defaultValue);
        if (resetButton != null) {
            resetButton.onPress(button -> textBox.text(defaultValue));
        }
        return textBox;
    }

    public static TextBoxRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = TextBoxRow.getId(element);
        String tooltipId = TextBoxRow.getTooltipId(element, id);
        boolean removeResetButton = UIParsing.childElements((Element)element).containsKey("removeResetButton") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("removeResetButton")));
        boolean removeHorizontalMargins = UIParsing.childElements((Element)element).containsKey("removeHorizontalMargins") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("removeHorizontalMargins")));
        boolean symbolChatButtons = UIParsing.childElements((Element)element).containsKey("symbolChatButtons") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("symbolChatButtons")));
        TextBoxRow row = new TextBoxRow(baseTranslationKey, id, tooltipId, symbolChatButtons);
        if (removeHorizontalMargins) {
            row.removeHorizontalMargins();
        }
        if (removeResetButton) {
            row.removeResetButton();
        }
        TextBoxComponent textBox = (TextBoxComponent)row.childById(TextBoxComponent.class, TextBoxRow.getTextBoxId(id));
        class_437 screen = class_310.method_1551().field_1755;
        if (symbolChatButtons && screen instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseFzmmScreen = (BaseFzmmScreen)screen;
            if (textBox != null) {
                row.addSymbolChatButtons(baseFzmmScreen, (class_342)textBox);
            }
        }
        return row;
    }

    public void addSymbolChatButtons(BaseFzmmScreen screen, class_342 textFieldWidget) {
        List<Component> symbolChatButtons = screen.getSymbolChatCompat().getButtons(screen, textFieldWidget);
        if (symbolChatButtons.isEmpty()) {
            return;
        }
        Optional<FlowLayout> rightLayoutOptional = this.getRightLayout();
        if (rightLayoutOptional.isEmpty()) {
            return;
        }
        FlowLayout rightLayout = rightLayoutOptional.get();
        List componentList = List.copyOf(rightLayout.children());
        rightLayout.clearChildren();
        rightLayout.children(symbolChatButtons);
        rightLayout.children(componentList);
    }
}

