/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.encrypt_book;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.containers.ConfirmOverlay;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.encrypt_book.components.AddEncryptProfileOverlay;
import fzmm.zailer.me.client.gui.encrypt_book.components.DecryptorSaverOverlay;
import fzmm.zailer.me.client.logic.enycrpt_book.EncryptbookLogic;
import fzmm.zailer.me.client.logic.enycrpt_book.TranslationEncryptProfile;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.config.FzmmConfig;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.FocusHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class EncryptBookScreen
extends BaseFzmmScreen
implements IMemento {
    private TextAreaComponent messageTextArea;
    private TextBoxComponent paddingCharactersField;
    private TextBoxComponent authorField;
    private TextBoxComponent titleField;
    private FlowLayout decryptorProfileLayout;
    private LabelComponent decryptorStatus;
    @Nullable
    private TranslationEncryptProfile selectedProfile = null;
    private int selectedProfileIndex;

    public EncryptBookScreen(@Nullable class_437 parent) {
        super("encrypt_book", "encryptbook", parent);
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        FzmmConfig.Encryptbook config = FzmmClient.CONFIG.encryptbook;
        this.messageTextArea = rootComponent.childByIdOrThrow(TextAreaComponent.class, "message-text-area");
        this.messageTextArea.text(config.defaultBookMessage());
        this.authorField = TextBoxRow.setup(rootComponent, "author", this.field_22787.field_1724.method_5477().getString(), 512);
        this.titleField = TextBoxRow.setup(rootComponent, "title", config.defaultBookTitle(), 32);
        String configPadding = config.padding();
        this.paddingCharactersField = TextBoxRow.setup(rootComponent, "paddingCharacters", configPadding, 512);
        rootComponent.childByIdOrThrow(ButtonComponent.class, "add-profile-button").onPress(this::addProfileOverlay);
        TextBoxComponent textBoxComponent = this.paddingCharactersField;
        if (textBoxComponent instanceof SuggestionTextBox) {
            SuggestionTextBox suggestionTextBox = (SuggestionTextBox)textBoxComponent;
            suggestionTextBox.setSuggestionProvider((context, builder) -> {
                String defaultValue = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,.";
                builder.suggest(defaultValue);
                if (!defaultValue.equals(configPadding)) {
                    builder.suggest(configPadding);
                }
                return CompletableFuture.completedFuture(builder.build());
            });
        }
        this.decryptorStatus = rootComponent.childByIdOrThrow(ELabelComponent.class, "profile-status");
        rootComponent.childByIdOrThrow(ButtonComponent.class, "get-decryptor-button").onPress(buttonComponent -> this.decryptorSaverOverlay(this.selectedProfile));
        this.decryptorProfileLayout = rootComponent.childByIdOrThrow(EFlowLayout.class, "profile-list");
        this.updateDecryptorProfileList();
        this.selectProfile(0);
        rootComponent.childByIdOrThrow(ButtonComponent.class, "give-button").onPress(buttonComponent -> this.giveBook(false));
        rootComponent.childByIdOrThrow(ButtonComponent.class, "add-page-button").onPress(buttonComponent -> this.giveBook(true));
        rootComponent.childByIdOrThrow(ButtonComponent.class, "faq-button").onPress(this::faqExecute);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.messageTextArea, Component.FocusSource.MOUSE_CLICK);
    }

    private void updateDecryptorProfileList() {
        List<TranslationEncryptProfile> decryptorProfiles = EncryptBookScreen.getProfiles();
        ArrayList<EFlowLayout> componentList = new ArrayList<EFlowLayout>();
        int i = 0;
        while (i < decryptorProfiles.size()) {
            TranslationEncryptProfile profile = decryptorProfiles.get(i);
            int finalI = i++;
            EFlowLayout component = (EFlowLayout)((EFlowLayout)this.getModel().expandTemplate(EFlowLayout.class, "profile-option", Map.of())).configure(layout -> {
                ELabelComponent label = layout.childByIdOrThrow(ELabelComponent.class, "label");
                label.text((class_2561)class_2561.method_43469((String)"fzmm.gui.encryptbook.label.profile", (Object[])new Object[]{profile.translationKey(), profile.length(), profile.isAsymmetric(), profile.isOldAlgorithm()}));
                layout.mouseDown().subscribe((mouseX, mouseY, button) -> this.profileSelect((FlowLayout)layout, profile, finalI));
                ButtonComponent removeButton = layout.childByIdOrThrow(ButtonComponent.class, "remove-button");
                removeButton.onPress(button -> this.addOverlay((Component)new ConfirmOverlay((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.label.removeDecryptor"), aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        FzmmClient.CONFIG.encryptbook.profiles().remove(profile.toModel());
                        FzmmClient.CONFIG.save();
                        layout.remove();
                        this.updateDecryptorStatus(this.selectedProfile);
                    }
                })));
            });
            componentList.add(component);
        }
        this.decryptorProfileLayout.clearChildren();
        this.decryptorProfileLayout.children(componentList);
    }

    private boolean profileSelect(FlowLayout profileLayout, TranslationEncryptProfile profile, int index) {
        this.selectedProfile = profile;
        this.selectedProfileIndex = index;
        for (Component child : this.decryptorProfileLayout.children()) {
            if (!(child instanceof FlowLayout)) continue;
            FlowLayout childLayout = (FlowLayout)child;
            Surface surface = Surface.flat((int)(childLayout == profileLayout ? 0x70000000 : 0x40000000));
            childLayout.surface(surface);
        }
        this.updateDecryptorStatus(profile);
        this.messageTextArea.method_44402(profile.length());
        return true;
    }

    public void addProfileOverlay(class_4185 buttonWidget) {
        this.addOverlay((Component)new AddEncryptProfileOverlay(profile -> {
            FzmmClient.CONFIG.encryptbook.profiles().add(profile.toModel());
            FzmmClient.CONFIG.save();
            this.updateDecryptorProfileList();
            this.selectProfile(this.decryptorProfileLayout.children().size() - 1);
            this.decryptorSaverOverlay((TranslationEncryptProfile)profile);
        }));
    }

    private void decryptorSaverOverlay(TranslationEncryptProfile profile) {
        this.addOverlay((Component)new DecryptorSaverOverlay(profile));
    }

    public void selectProfile(int index) {
        List profileLayout = this.decryptorProfileLayout.children();
        if (profileLayout.isEmpty()) {
            return;
        }
        int selectedProfileIndex = index < profileLayout.size() ? index : 0;
        ((Component)profileLayout.get(selectedProfileIndex)).onMouseDown(0.0, 0.0, 0);
    }

    public void updateDecryptorStatus(@Nullable TranslationEncryptProfile profile) {
        class_5250 result;
        boolean isValid = false;
        String translationValue = "fzmm.gui.encryptbook.label.profile.";
        if (profile != null && class_1074.method_4663((String)profile.translationKey())) {
            String decryptString = class_2561.method_43471((String)profile.translationKey()).getString();
            isValid = decryptString.equals(profile.decryptorValue());
            String status = isValid ? "loaded" : "outdated";
            result = class_2561.method_43471((String)(translationValue + status));
        } else {
            result = class_2561.method_43471((String)(translationValue + "notFound"));
        }
        result = result.method_27661().method_10862(class_2583.field_24360.method_36139((isValid ? EStyles.TEXT_SUCCESS_COLOR : EStyles.TEXT_ERROR_COLOR).rgb()));
        this.decryptorStatus.text((class_2561)result);
    }

    private void giveBook(boolean isAddPage) {
        String paddingChars;
        if (this.selectedProfile == null) {
            return;
        }
        FzmmConfig.Encryptbook config = FzmmClient.CONFIG.encryptbook;
        String message = this.messageTextArea.method_44405();
        if (message.isEmpty()) {
            message = config.defaultBookMessage();
        }
        if ((paddingChars = this.paddingCharactersField.method_1882()).isEmpty()) {
            paddingChars = " ";
        }
        String author = this.authorField.method_1882();
        String title = this.titleField.method_1882();
        EncryptbookLogic.give(message, author, paddingChars, title, this.selectedProfile, isAddPage);
    }

    private void faqExecute(class_4185 buttonWidget) {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://github.com/Zailer43/FZMM-Mod/blob/1.21.5/dev/docs/en/wiki/encrypt_book/0.2.14_encrypt_book.md", (boolean)true);
    }

    public static List<TranslationEncryptProfile> getProfiles() {
        return TranslationEncryptProfile.of(FzmmClient.CONFIG.encryptbook.profiles());
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.messageTextArea.method_44405());
        output.writeObject(this.authorField.method_1882());
        output.writeObject(this.titleField.method_1882());
        output.writeObject(this.paddingCharactersField.method_1882());
        output.writeInt(this.selectedProfileIndex);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.messageTextArea.text((String)input.readObject());
        this.authorField.text((String)input.readObject());
        this.titleField.text((String)input.readObject());
        this.paddingCharactersField.text((String)input.readObject());
        this.selectProfile(input.readInt());
    }
}

