/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_generator;

import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.SnackBarBuilder;
import fzmm.zailer.me.client.gui.head_generator.category.IHeadCategory;
import fzmm.zailer.me.client.gui.head_generator.components.AbstractHeadComponentEntry;
import fzmm.zailer.me.client.gui.head_generator.components.HeadComponentEntry;
import fzmm.zailer.me.client.gui.head_generator.components.HeadComponentOverlay;
import fzmm.zailer.me.client.gui.head_generator.components.HeadCompoundComponentEntry;
import fzmm.zailer.me.client.gui.head_generator.options.ISkinPreEdit;
import fzmm.zailer.me.client.gui.head_generator.options.SkinPreEditOption;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.InternalModels;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.HeadUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.SkinPart;
import fzmm.zailer.me.utils.list.ListUtils;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.FocusHandler;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class HeadGeneratorScreen
extends BaseFzmmScreen
implements IMemento {
    private static final int COMPOUND_HEAD_LAYOUT_WIDTH = 60;
    private static final int HEAD_PREVIEW_SCHEDULE_DELAY_MILLIS = 1;
    public static final Path SKIN_SAVE_FOLDER_PATH = Path.of(FabricLoader.getInstance().getGameDir().toString(), "fzmm", "skins");
    private final Set<String> favoritesHeadsOnOpenScreen;
    private ImageRowsElements skinElements;
    private TextBoxComponent headNameField;
    private HashMap<SkinPreEditOption, ButtonComponent> skinPreEditButtons;
    private SkinPreEditOption selectedSkinPreEdit;
    private TextBoxComponent searchField;
    private List<HeadComponentEntry> headComponentEntries;
    private List<HeadCompoundComponentEntry> compoundEntries;
    private FlowLayout contentLayout;
    private EFlowLayout compoundHeadsLayout;
    private ButtonComponent toggleFavoriteList;
    private boolean showFavorites;
    private BufferedImage baseSkin;
    private boolean hasUnusedPixels;
    private String previousSkinName;
    private IHeadCategory selectedCategory;
    private ButtonComponent giveButton;
    private Animation.Composed compoundExpandAnimation;
    private ContextMenuButton headCategoryButton;

    public HeadGeneratorScreen(@Nullable class_437 parent) {
        super("head_generator", "headGenerator", parent);
        this.favoritesHeadsOnOpenScreen = Set.copyOf(FzmmClient.CONFIG.headGenerator.favoriteSkins());
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        this.headComponentEntries = new ArrayList<HeadComponentEntry>();
        this.compoundEntries = new ArrayList<HeadCompoundComponentEntry>();
        this.baseSkin = new BufferedImage(64, 64, 2);
        this.skinElements = ImageRows.setup(rootComponent, "skin", "skinSourceType", ImageMode.NAME);
        this.skinElements.imageButton().setButtonCallback(skinOptional -> skinOptional.ifPresent(this::skinCallback));
        this.previousSkinName = "";
        this.headNameField = TextBoxRow.setup(rootComponent, "headName", "", 16);
        this.skinElements.valueField().onChanged().subscribe(this::onChangeSkinField);
        this.contentLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "content");
        this.compoundHeadsLayout = rootComponent.childByIdOrThrow(EFlowLayout.class, "compound-heads-layout");
        int animationDuration = 800;
        Animation headsLayoutMarginAnimation = this.compoundHeadsLayout.margins().animate(animationDuration, Easing.CUBIC, (Animatable)Insets.of((int)0, (int)0, (int)0, (int)6));
        Animation compoundHeadsLayoutAnimation = this.compoundHeadsLayout.horizontalSizing().animate(animationDuration, Easing.CUBIC, (Animatable)Sizing.fixed((int)60));
        Animation compoundHeadsLayoutPaddingAnimation = this.compoundHeadsLayout.padding().animate(animationDuration, Easing.CUBIC, (Animatable)Insets.of((int)6));
        this.compoundExpandAnimation = Animation.compose((Animation[])new Animation[]{compoundHeadsLayoutAnimation, headsLayoutMarginAnimation, compoundHeadsLayoutPaddingAnimation});
        ButtonComponent openSkinFolderButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "open-folder-button");
        openSkinFolderButton.onPress(button -> class_156.method_668().method_672(SKIN_SAVE_FOLDER_PATH.toFile()));
        this.searchField = TextBoxRow.setup(rootComponent, "search", "", 128, s -> this.applyFilters());
        this.skinPreEditButtons = new HashMap();
        for (SkinPreEditOption preEditOption : SkinPreEditOption.values()) {
            FlowLayout skinPreEditButtonLayout = rootComponent.childByIdOrThrow(FlowLayout.class, preEditOption.getId());
            this.setupPreEditButton(skinPreEditButtonLayout, preEditOption, this.skinPreEditButtons, skinPreEditOption -> {
                this.selectedSkinPreEdit = skinPreEditOption;
                if (this.skinElements.imageButton().hasImage()) {
                    this.updateContentPreviews();
                }
            });
        }
        this.skinPreEditButtons.get(SkinPreEditOption.OVERLAP).method_25306();
        this.headCategoryButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "head-category-button");
        this.selectedCategory = IHeadCategory.NATURAL_CATEGORIES[0];
        this.updateCategoryTitle(this.selectedCategory);
        int maxCategoryHorizontalSizing = FzmmUtils.getMaxWidth(Arrays.asList(IHeadCategory.NATURAL_CATEGORIES), this::getCategoryText) + 8;
        this.headCategoryButton.horizontalSizing(Sizing.fixed((int)maxCategoryHorizontalSizing));
        this.headCategoryButton.setContextMenuOptions(contextMenu -> {
            for (IHeadCategory category : IHeadCategory.NATURAL_CATEGORIES) {
                contextMenu.button((class_2561)class_2561.method_43471((String)category.getTranslationKey()), dropdown -> this.updateCategory(category));
            }
        });
        this.toggleFavoriteList = rootComponent.childByIdOrThrow(ButtonComponent.class, "toggle-favorite-list");
        this.toggleFavoriteList.onPress(buttonComponent -> this.toggleFavoriteListExecute());
        this.showFavorites = false;
        int toggleFavoriteListWidth = FzmmUtils.getMaxWidth(List.of(HeadComponentEntry.FAVORITE_DISABLED_TEXT, HeadComponentEntry.FAVORITE_ENABLED_TEXT)) + 8;
        this.toggleFavoriteList.horizontalSizing(Sizing.fixed((int)Math.max(20, toggleFavoriteListWidth)));
        this.updateToggleFavoriteText();
        ButtonComponent wikiButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "wiki-button");
        wikiButton.onPress(buttonComponent -> this.wikiExecute());
        this.tryLoadHeadEntries(rootComponent);
        this.updateContentPreviews();
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.skinElements.valueField(), Component.FocusSource.MOUSE_CLICK);
    }

    private void updateCategory(IHeadCategory category) {
        this.selectedCategory = category;
        this.applyFilters();
        this.updateCategoryTitle(category);
        this.updateTogglePreEdit();
    }

    private void updateCategoryTitle(IHeadCategory category) {
        this.headCategoryButton.method_25355((class_2561)this.getCategoryText(category));
    }

    private void updateTogglePreEdit() {
        if (!FzmmClient.CONFIG.headGenerator.forcePreEditNoneInModels()) {
            return;
        }
        for (SkinPreEditOption preEditOption : this.skinPreEditButtons.keySet()) {
            this.skinPreEditButtons.get((Object)preEditOption).field_22763 = !this.selectedCategory.isModel() && preEditOption != this.selectedSkinPreEdit;
        }
    }

    private class_5250 getCategoryText(IHeadCategory category) {
        return class_2561.method_43469((String)"fzmm.gui.headGenerator.label.category", (Object[])new Object[]{class_2561.method_43471((String)category.getTranslationKey())});
    }

    private void skinCallback(BufferedImage skinBase) {
        if (ImageUtils.isEquals(skinBase, this.baseSkin)) {
            return;
        }
        this.hasUnusedPixels = ImageUtils.hasUnusedPixel(skinBase);
        if (skinBase.getWidth() == 64 && skinBase.getHeight() == 32) {
            skinBase = InternalModels.OLD_FORMAT_TO_NEW_FORMAT.getHeadSkin(skinBase, this.hasUnusedPixels);
            this.skinElements.imageButton().setImage(skinBase);
        }
        this.baseSkin = skinBase;
        this.updateCompoundPreviews(0);
        this.updateContentPreviews();
    }

    private void tryLoadHeadEntries(EFlowLayout rootComponent) {
        if (!this.contentLayout.children().isEmpty()) {
            return;
        }
        List<HeadComponentEntry> headComponentList = HeadResourcesLoader.getLoaded().stream().map(entry -> new HeadComponentEntry((AbstractHeadEntry)entry, this)).toList();
        if (headComponentList.isEmpty()) {
            this.addNoResultsMessage(rootComponent);
            return;
        }
        this.headComponentEntries.addAll(headComponentList);
        this.applyFilters();
    }

    private void addNoResultsMessage(EFlowLayout parent) {
        FzmmClient.LOGGER.warn("[HeadGeneratorScreen] No head entries found");
        Component label = EComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.label.noResults").method_10862(class_2583.field_24360.method_36139(EStyles.TEXT_ERROR_COLOR.rgb()))).horizontalTextAlignment(HorizontalAlignment.CENTER).sizing(Sizing.expand((int)100), Sizing.content()).margins(Insets.top((int)4));
        FlowLayout layout = parent.childByIdOrThrow(FlowLayout.class, "no-results-label-layout");
        layout.child(label);
    }

    public void updateContentPreviews() {
        assert (this.field_22787 != null);
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        boolean editingBody = this.isEditingBody();
        SkinPreEditOption skinPreEditOption = this.skinPreEdit();
        boolean forcePreEditNone = FzmmClient.CONFIG.headGenerator.forcePreEditNoneInModels();
        boolean isSlim = ImageUtils.isSlimSimpleCheck(this.baseSkin);
        BufferedImage selectedPreEdit = this.preEditContent(skinPreEditOption, editingBody);
        BufferedImage bodyTexturePreEdit = editingBody ? selectedPreEdit : this.preEditContent(skinPreEditOption, true);
        BufferedImage nonePreEdit = this.preEditContent(SkinPreEditOption.NONE, editingBody);
        AtomicInteger index = new AtomicInteger(1);
        for (int i = 0; i != this.headComponentEntries.size(); ++i) {
            HeadComponentEntry entry = this.headComponentEntries.get(i);
            scheduler.schedule(() -> this.field_22787.execute(() -> {
                BufferedImage baseTexture = forcePreEditNone && entry.getValue() instanceof HeadModelEntry ? nonePreEdit : (entry.getValue().isEditingSkinBody() ? bodyTexturePreEdit : selectedPreEdit);
                entry.basePreview(baseTexture, this.hasUnusedPixels);
                entry.updateModel(isSlim);
            }), 1L * (long)index.getAndIncrement(), TimeUnit.MILLISECONDS);
        }
        scheduler.schedule(() -> {
            selectedPreEdit.flush();
            bodyTexturePreEdit.flush();
            nonePreEdit.flush();
        }, (long)((this.headComponentEntries.size() + 2) * 1), TimeUnit.MILLISECONDS);
        scheduler.shutdown();
    }

    public void updateCompoundPreviews(HeadCompoundComponentEntry modifiedEntry, int indexOffset) {
        this.updateCompoundPreviews(this.compoundEntries.indexOf(modifiedEntry) + indexOffset);
    }

    private void updateCompoundPreviews(int index) {
        if (index < 0 || index >= this.compoundEntries.size()) {
            return;
        }
        BufferedImage texture = this.getBaseTextureOfCompound(index);
        boolean isEditingBody = this.isEditingBody();
        BufferedImage textureCopy = new BufferedImage(texture.getWidth(), texture.getHeight(), 2);
        textureCopy.getGraphics().drawImage(texture, 0, 0, null);
        Graphics2D graphics = textureCopy.createGraphics();
        ISkinPreEdit none = SkinPreEditOption.NONE.getPreEdit();
        ISkinPreEdit overlap = SkinPreEditOption.OVERLAP.getPreEdit();
        SkinPreEditOption.OVERLAP.getPreEdit().apply(graphics, textureCopy, isEditingBody);
        for (int i = index; i != this.compoundEntries.size(); ++i) {
            HeadCompoundComponentEntry compoundEntry = this.compoundEntries.get(i);
            compoundEntry.basePreview(textureCopy, this.hasUnusedPixels);
            none.apply(graphics, compoundEntry.getPreview());
            overlap.apply(graphics, textureCopy, isEditingBody);
        }
        graphics.dispose();
        textureCopy.flush();
    }

    private void updateCompoundSkinFormat() {
        boolean isEditingBody = this.isEditingBody();
        boolean isSlim = ImageUtils.isSlimSimpleCheck(this.baseSkin);
        for (HeadCompoundComponentEntry compoundEntry : this.compoundEntries) {
            compoundEntry.setBodyPreview(isEditingBody || compoundEntry.getValue().isEditingSkinBody());
            compoundEntry.updateModel(isSlim);
        }
    }

    private BufferedImage getBaseTextureOfCompound(int index) {
        if (index == 0) {
            return this.baseSkin;
        }
        return this.compoundEntries.get(index - 1).getPreview();
    }

    private boolean isEditingBody() {
        return this.compoundEntries.stream().anyMatch(entry -> entry.getValue().isEditingSkinBody());
    }

    public BufferedImage preEdit(AbstractHeadComponentEntry entry, SkinPreEditOption skinPreEditOption, boolean editBody) {
        if (entry instanceof HeadCompoundComponentEntry) {
            BufferedImage baseTexture = this.getBaseTextureOfCompound(this.compoundEntries.indexOf(entry));
            return this.preEditCompound(baseTexture, skinPreEditOption, editBody);
        }
        return this.preEditContent(skinPreEditOption, editBody);
    }

    public BufferedImage preEditCompound(BufferedImage preview, SkinPreEditOption skinPreEditOption, boolean editBody) {
        BufferedImage result = new BufferedImage(64, 64, 2);
        Graphics2D graphics = result.createGraphics();
        skinPreEditOption.getPreEdit().apply(graphics, preview, SkinPart.HEAD);
        (editBody ? skinPreEditOption : SkinPreEditOption.NONE).getPreEdit().apply(graphics, preview, SkinPart.BODY_PARTS);
        if (this.hasUnusedPixels) {
            ImageUtils.copyUnusedPixels(preview, graphics);
        }
        graphics.dispose();
        return result;
    }

    private BufferedImage preEditContent(SkinPreEditOption skinPreEditOption, boolean editBody) {
        BufferedImage texture = this.baseSkin;
        if (!this.compoundEntries.isEmpty()) {
            texture = this.compoundEntries.get(this.compoundEntries.size() - 1).getPreview();
            Graphics2D graphics = texture.createGraphics();
            skinPreEditOption.getPreEdit().apply(graphics, texture);
            graphics.dispose();
        }
        return this.preEditCompound(texture, skinPreEditOption, editBody);
    }

    public boolean hasUnusedPixels() {
        return this.hasUnusedPixels;
    }

    public void setupPreEditButton(FlowLayout preEditLayout, SkinPreEditOption preEditOption, HashMap<SkinPreEditOption, ButtonComponent> skinPreEditButtons, Consumer<SkinPreEditOption> selectPreEditCallback) {
        preEditLayout.tooltip((class_2561)class_2561.method_43471((String)(preEditOption.getTranslationKey() + ".tooltip")));
        ButtonComponent preEditButton = Components.button((class_2561)class_2561.method_43473(), button -> {
            selectPreEditCallback.accept(preEditOption);
            for (SkinPreEditOption option : skinPreEditButtons.keySet()) {
                if (option == preEditOption) continue;
                ((ButtonComponent)skinPreEditButtons.get((Object)option)).field_22763 = true;
            }
            button.field_22763 = false;
        });
        preEditButton.horizontalSizing(Sizing.fixed((int)20));
        preEditButton.renderer((context, button, delta) -> {
            ButtonComponent.Renderer.VANILLA.draw(context, button, delta);
            preEditOption.getIcon().render((class_332)context, button.x() + 2, button.y() + 2, 0, 0, delta);
        });
        skinPreEditButtons.put(preEditOption, preEditButton);
        preEditLayout.child((Component)preEditButton);
    }

    private void closeTextures() {
        if (this.contentLayout == null) {
            return;
        }
        assert (this.field_22787 != null);
        this.field_22787.execute(() -> {
            this.closeTextures(this.headComponentEntries);
            this.closeTextures(this.compoundEntries);
        });
    }

    private void closeTextures(List<? extends AbstractHeadComponentEntry> entries) {
        for (AbstractHeadComponentEntry abstractHeadComponentEntry : entries) {
            abstractHeadComponentEntry.close();
        }
    }

    private void applyFilters() {
        if (this.searchField == null) {
            return;
        }
        String searchValue = this.searchField.method_1882().toLowerCase();
        for (HeadComponentEntry entry : this.headComponentEntries) {
            entry.filter(searchValue, this.showFavorites, this.selectedCategory);
        }
        ArrayList<HeadComponentEntry> newResults = new ArrayList<HeadComponentEntry>(this.headComponentEntries);
        newResults.removeIf(component -> {
            HeadComponentEntry entry;
            return component instanceof HeadComponentEntry && (entry = (HeadComponentEntry)component).isHide();
        });
        this.contentLayout.clearChildren();
        this.contentLayout.children(newResults);
    }

    public void giveHead(BufferedImage image, String textureName) {
        assert (this.field_22787 != null);
        this.field_22787.execute(() -> {
            this.setUndefinedDelay();
            String headName = this.getHeadName();
            ISnackBarComponent snackBar = BaseSnackBarComponent.builder("head_generator").title((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.loading")).backgroundColor(EStyles.ALERT_LOADING_COLOR).keepOnLimit().build();
            this.addSnackBar(snackBar);
            new HeadUtils().uploadHead(image, headName + " + " + textureName).thenAccept(headUtils -> {
                HeadBuilder builder = headUtils.getBuilder();
                if (!headName.isBlank()) {
                    builder.headName(headName);
                }
                boolean generated = ItemUtils.give(builder.get());
                this.field_22787.execute(() -> {
                    this.setDelay(headUtils.getDelayForNext(TimeUnit.SECONDS));
                    snackBar.close();
                    if (generated) {
                        this.addStatusSnackBar((HeadUtils)headUtils, image, textureName);
                    }
                });
            });
        });
    }

    private void addStatusSnackBar(HeadUtils headUtils, BufferedImage image, String textureName) {
        SnackBarBuilder snackBar = BaseSnackBarComponent.builder("head_generator");
        if (headUtils.isSkinGenerated()) {
            snackBar.title((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.success")).lowTimer().backgroundColor(EStyles.ALERT_SUCCESS_COLOR).startTimer();
        } else if (headUtils.getHttpResponseCode() == 403) {
            snackBar.title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.mineskin.error.invalidApiKey")).details((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.mineskin.error.invalidApiKey.description")).backgroundColor(EStyles.ALERT_ERROR_COLOR).keepOnLimit().button(iSnackBarComponent -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.configs.icon"), buttonComponent -> this.setScreen((class_437)ConfigScreen.create((ConfigWrapper)FzmmClient.CONFIG, (class_437)this)))).highTimer().closeButton();
        } else {
            String translationKey = headUtils.getHttpResponseCode() / 500 == 5 ? "external" : "internal";
            snackBar.title((class_2561)class_2561.method_43471((String)("fzmm.gui.headGenerator.snack_bar.error." + translationKey))).details((class_2561)class_2561.method_43469((String)("fzmm.gui.headGenerator.snack_bar.error." + translationKey + ".description"), (Object[])new Object[]{headUtils.getHttpResponseCode()})).backgroundColor(EStyles.ALERT_ERROR_COLOR).keepOnLimit().button(iSnackBarComponent -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.error.button.retry"), buttonComponent -> {
                this.giveHead(image, textureName);
                iSnackBarComponent.close();
            })).highTimer().closeButton();
        }
        this.addSnackBar(snackBar.build());
    }

    public void setUndefinedDelay() {
        class_5250 waitMessage = class_2561.method_43471((String)"fzmm.gui.headGenerator.wait");
        this.updateButton((class_2561)waitMessage, false);
    }

    public void setDelay(int seconds) {
        for (int i = 0; i != seconds; ++i) {
            class_5250 message = class_2561.method_43469((String)"fzmm.gui.headGenerator.wait_seconds", (Object[])new Object[]{seconds - i});
            CompletableFuture.delayedExecutor(i, TimeUnit.SECONDS).execute(() -> this.lambda$setDelay$24((class_2561)message));
        }
        CompletableFuture.delayedExecutor(seconds, TimeUnit.SECONDS).execute(() -> this.updateButton(HeadComponentOverlay.GIVE_BUTTON_TEXT, true));
    }

    public void updateButton(class_2561 message, boolean active) {
        if (this.giveButton != null) {
            this.giveButton.method_25355(message);
            this.giveButton.field_22763 = active;
        }
    }

    public void setCurrentGiveButton(ButtonComponent currentGiveButton) {
        if (this.giveButton != null) {
            class_2561 message = this.giveButton.method_25369();
            boolean active = this.giveButton.field_22763;
            this.giveButton = currentGiveButton;
            this.updateButton(message, active);
        } else {
            this.giveButton = currentGiveButton;
        }
    }

    public String getHeadName() {
        return this.headNameField.method_1882();
    }

    public void addCompound(AbstractHeadEntry headData, BufferedImage currentPreview) {
        assert (this.field_22787 != null);
        List compoundHeads = this.compoundHeadsLayout.children();
        if (compoundHeads.isEmpty()) {
            this.compoundExpandAnimation.forwards();
            this.compoundHeadsLayout.surface(this.compoundHeadsLayout.styledPanel());
        }
        HeadCompoundComponentEntry entry = new HeadCompoundComponentEntry(headData, this.compoundHeadsLayout, this, currentPreview);
        this.compoundEntries.add(entry);
        this.compoundHeadsLayout.child((Component)entry);
        this.updateCompoundSkinFormat();
        this.updateContentPreviews();
    }

    public void removeCompound(HeadCompoundComponentEntry entry) {
        int index = this.compoundEntries.indexOf(entry);
        this.compoundEntries.remove(entry);
        entry.remove();
        if (this.compoundEntries.isEmpty()) {
            this.compoundExpandAnimation.backwards();
            this.compoundHeadsLayout.surface(Surface.BLANK);
        }
        this.updateCompoundSkinFormat();
        this.updateCompoundPreviews(index);
        this.updateContentPreviews();
    }

    private void toggleFavoriteListExecute() {
        this.showFavorites = !this.showFavorites;
        this.updateToggleFavoriteText();
        this.applyFilters();
    }

    private void updateToggleFavoriteText() {
        this.toggleFavoriteList.method_25355(this.showFavorites ? HeadComponentEntry.FAVORITE_ENABLED_TEXT : HeadComponentEntry.FAVORITE_DISABLED_TEXT);
    }

    private void wikiExecute() {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://github.com/Zailer43/FZMM-Mod/blob/1.21.5/dev/docs/en/wiki/head_generator/0.2.14_head_generator.md", (boolean)true);
    }

    public SkinPreEditOption skinPreEdit() {
        return this.selectedSkinPreEdit;
    }

    public void upCompoundEntry(HeadCompoundComponentEntry entry) {
        List<AbstractHeadComponentEntry> list = this.compoundHeadsLayout.children().stream().map(component -> (AbstractHeadComponentEntry)component).toList();
        ListUtils.upEntry(list, entry);
        this.updateCompoundPreviews(entry, -1);
        this.updateContentPreviews();
    }

    public void downCompoundEntry(HeadCompoundComponentEntry entry) {
        List<AbstractHeadComponentEntry> list = this.compoundHeadsLayout.children().stream().map(component -> (AbstractHeadComponentEntry)component).toList();
        ListUtils.downEntry(list, entry);
        this.updateCompoundPreviews(entry, 0);
        this.updateContentPreviews();
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.closeTextures();
    }

    @Override
    public void method_25432() {
        super.method_25432();
        if (!this.favoritesHeadsOnOpenScreen.equals(FzmmClient.CONFIG.headGenerator.favoriteSkins())) {
            FzmmClient.CONFIG.save();
        }
    }

    private void onChangeSkinField(String value) {
        AtomicReference<ImageMode> mode = this.skinElements.mode();
        if (mode.get().isHeadName() && this.headNameField.method_1882().equals(this.previousSkinName)) {
            this.headNameField.text(value);
        }
        this.previousSkinName = value;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject((Object)this.skinElements.mode().get());
        output.writeObject(this.skinElements.valueField().method_1882());
        output.writeObject(this.headNameField.method_1882());
        output.writeBoolean(this.showFavorites);
        output.writeObject(this.skinPreEdit());
        output.writeObject(this.selectedCategory);
        output.writeObject(this.searchField.method_1882());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.skinElements.imageModeButtons().get((Object)((ImageMode)((Object)input.readObject()))).method_25306();
        this.skinElements.valueField().text((String)input.readObject());
        this.headNameField.text((String)input.readObject());
        if (input.readBoolean()) {
            this.toggleFavoriteListExecute();
        }
        this.skinPreEditButtons.get((SkinPreEditOption)input.readObject()).method_25306();
        this.updateCategory((IHeadCategory)input.readObject());
        this.searchField.text((String)input.readObject());
    }

    private /* synthetic */ void lambda$setDelay$24(class_2561 message) {
        this.updateButton(message, false);
    }
}

