/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.algorithms;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.utils.ImageUtils;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class ImagetextBrailleAlgorithm
implements IImagetextAlgorithm {
    private static final String[] BRAILLE_CHARACTERS = "\u2800\u2801\u2802\u2803\u2804\u2805\u2806\u2807\u2840\u2841\u2842\u2843\u2844\u2845\u2846\u2847\u2808\u2809\u280a\u280b\u280c\u280d\u280e\u280f\u2848\u2849\u284a\u284b\u284c\u284d\u284e\u284f\u2810\u2811\u2812\u2813\u2814\u2815\u2816\u2817\u2850\u2851\u2852\u2853\u2854\u2855\u2856\u2857\u2818\u2819\u281a\u281b\u281c\u281d\u281e\u281f\u2858\u2859\u285a\u285b\u285c\u285d\u285e\u285f\u2820\u2821\u2822\u2823\u2824\u2825\u2826\u2827\u2860\u2861\u2862\u2863\u2864\u2865\u2866\u2867\u2828\u2829\u282a\u282b\u282c\u282d\u282e\u282f\u2868\u2869\u286a\u286b\u286c\u286d\u286e\u286f\u2830\u2831\u2832\u2833\u2834\u2835\u2836\u2837\u2870\u2871\u2872\u2873\u2874\u2875\u2876\u2877\u2838\u2839\u283a\u283b\u283c\u283d\u283e\u283f\u2878\u2879\u287a\u287b\u287c\u287d\u287e\u287f\u2880\u2881\u2882\u2883\u2884\u2885\u2886\u2887\u28c0\u28c1\u28c2\u28c3\u28c4\u28c5\u28c6\u28c7\u2888\u2889\u288a\u288b\u288c\u288d\u288e\u288f\u28c8\u28c9\u28ca\u28cb\u28cc\u28cd\u28ce\u28cf\u2890\u2891\u2892\u2893\u2894\u2895\u2896\u2897\u28d0\u28d1\u28d2\u28d3\u28d4\u28d5\u28d6\u28d7\u2898\u2899\u289a\u289b\u289c\u289d\u289e\u289f\u28d8\u28d9\u28da\u28db\u28dc\u28dd\u28de\u28df\u28a0\u28a1\u28a2\u28a3\u28a4\u28a5\u28a6\u28a7\u28e0\u28e1\u28e2\u28e3\u28e4\u28e5\u28e6\u28e7\u28a8\u28a9\u28aa\u28ab\u28ac\u28ad\u28ae\u28af\u28e8\u28e9\u28ea\u28eb\u28ec\u28ed\u28ee\u28ef\u28b0\u28b1\u28b2\u28b3\u28b4\u28b5\u28b6\u28b7\u28f0\u28f1\u28f2\u28f3\u28f4\u28f5\u28f6\u28f7\u28b8\u28b9\u28ba\u28bb\u28bc\u28bd\u28be\u28bf\u28f8\u28f9\u28fa\u28fb\u28fc\u28fd\u28fe\u28ff".split("");
    private static final byte BRAILLE_CHARACTER_WIDTH = 2;
    private static final byte BRAILLE_CHARACTER_HEIGHT = 4;
    private SliderWidget edgeThresholdSlider;
    private SliderWidget edgeDistanceSlider;
    private SmallCheckboxComponent invertBooleanButton;
    private String[][] brailleImage = null;
    private BufferedImage colorsImage = null;
    private byte[][] grayScaleUpscaledImage = null;
    private final float widthRatio;

    public ImagetextBrailleAlgorithm() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int defaultWidth = textRenderer.method_1727("\u2588");
        int brailleWidth = textRenderer.method_1727(BRAILLE_CHARACTERS[BRAILLE_CHARACTERS.length - 1]);
        if (brailleWidth == 0 || defaultWidth == 0) {
            defaultWidth = 1;
            brailleWidth = 1;
        }
        this.widthRatio = (float)brailleWidth / (float)defaultWidth;
    }

    @Override
    public BufferedImage image() {
        return this.colorsImage;
    }

    @Override
    public void image(BufferedImage image) {
        this.colorsImage = image;
    }

    @Override
    public void build() {
        if (this.grayScaleUpscaledImage == null) {
            FzmmClient.LOGGER.warn("[ImagetextBrailleAlgorithm] No image set");
            return;
        }
        this.brailleImage = this.brailleImageOf(this.grayScaleUpscaledImage, this.grayScaleUpscaledImage.length / 2, this.grayScaleUpscaledImage[0].length / 4);
    }

    @Override
    public String getId() {
        return "braille";
    }

    @Override
    public String[] linePixels(int line) {
        return this.brailleImage[line];
    }

    @Override
    public String pixelExample() {
        return BRAILLE_CHARACTERS[BRAILLE_CHARACTERS.length - 1];
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.edgeThresholdSlider = SliderRow.setup(rootComponent, "edgeThreshold", 30.0, 1.0, 255.0, Integer.class, 0, 5.0, null);
        this.edgeThresholdSlider.message(s -> {
            double percentage = this.edgeThresholdSlider.discreteValue() / 255.0 * 100.0;
            return class_2561.method_43470((String)(new DecimalFormat("#,##0.0").format(percentage) + "%"));
        });
        this.edgeDistanceSlider = SliderRow.setup(rootComponent, "edgeDistance", 2.0, 1.0, 5.0, Integer.class, 0, 1.0, null);
        this.invertBooleanButton = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "invert-checkbox");
        this.invertBooleanButton.checked(false);
    }

    @Override
    public float widthRatio() {
        return this.widthRatio;
    }

    @Override
    public float heightRatio() {
        return 1.0f / this.widthRatio;
    }

    @Override
    public void setUpdatePreviewCallback(Runnable callback) {
        this.edgeThresholdSlider.onChanged().subscribe(value -> callback.run());
        this.edgeDistanceSlider.onChanged().subscribe(value -> callback.run());
        this.invertBooleanButton.onChanged().subscribe(value -> callback.run());
    }

    @Override
    public boolean tryUpdateCache(ImagetextData data) {
        if (!IImagetextAlgorithm.super.tryUpdateCache(data)) {
            return false;
        }
        BufferedImage upscaledImage = ImageUtils.fastResizeImage(data.image(), data.width() * 2, data.height() * 4, data.smoothRescaling());
        this.grayScaleUpscaledImage = this.toGrayScale(upscaledImage);
        upscaledImage.flush();
        return true;
    }

    @Override
    public void clearCache() {
        IImagetextAlgorithm.super.clearCache();
        this.grayScaleUpscaledImage = null;
    }

    protected String[][] brailleImageOf(byte[][] grayScaleImage, int width, int height) {
        String[][] result = new String[height][width];
        int edgeThreshold = (int)this.edgeThresholdSlider.discreteValue();
        int edgeDistance = (int)this.edgeDistanceSlider.discreteValue();
        for (int y = 0; y != height; ++y) {
            int yOffset = y * 4;
            for (int x = 0; x != width; ++x) {
                int xOffset = x * 2;
                result[y][x] = this.brailleCharOf(grayScaleImage, xOffset, yOffset, edgeThreshold, edgeDistance);
            }
        }
        return result;
    }

    protected String brailleCharOf(byte[][] grayScaleImage, int x, int y, int edgeThreshold, int edgeDistance) {
        int index = BRAILLE_CHARACTERS.length - 1;
        int yOffset = y;
        index -= this.brailleCharIndexOf(0, grayScaleImage, x, yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(1, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(2, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(3, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        yOffset = y;
        index -= this.brailleCharIndexOf(4, grayScaleImage, ++x, yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(5, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(6, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        index -= this.brailleCharIndexOf(7, grayScaleImage, x, ++yOffset, edgeThreshold, edgeDistance);
        if (this.invertBooleanButton.checked()) {
            index = BRAILLE_CHARACTERS.length - 1 - index;
        }
        return BRAILLE_CHARACTERS[index];
    }

    protected int brailleCharIndexOf(int index, byte[][] grayScaleImage, int x, int y, int edgeThreshold, int edgeDistance) {
        return this.isEdge(grayScaleImage, x, y, edgeThreshold, edgeDistance) ? 1 << index : 0;
    }

    protected boolean isEdge(byte[][] grayScaleImage, int x, int y, int edgeThreshold, int edgeDistance) {
        byte pixel = grayScaleImage[x][y];
        byte left = x < edgeDistance ? pixel : grayScaleImage[x - edgeDistance][y];
        byte right = x > grayScaleImage.length - edgeDistance - 1 ? pixel : grayScaleImage[x + edgeDistance][y];
        byte top = y < edgeDistance ? pixel : grayScaleImage[x][y - edgeDistance];
        byte bottom = y > grayScaleImage[0].length - edgeDistance - 1 ? pixel : grayScaleImage[x][y + edgeDistance];
        return this.isEdgeThreshold(pixel, left, edgeThreshold) || this.isEdgeThreshold(pixel, right, edgeThreshold) || this.isEdgeThreshold(pixel, top, edgeThreshold) || this.isEdgeThreshold(pixel, bottom, edgeThreshold);
    }

    protected boolean isEdgeThreshold(byte pixelByte, byte edgePixelByte, int edgeThreshold) {
        int edgePixel;
        int pixel = Byte.toUnsignedInt(pixelByte);
        return pixel > (edgePixel = Byte.toUnsignedInt(edgePixelByte)) + edgeThreshold || pixel < edgePixel - edgeThreshold;
    }

    protected byte[][] toGrayScale(BufferedImage image) {
        byte[][] result = new byte[image.getWidth()][image.getHeight()];
        WritableRaster raster = image.getRaster();
        ColorModel colorModel = image.getColorModel();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Object elements = raster.getDataElements(x, y, null);
                int red = colorModel.getRed(elements);
                int green = colorModel.getGreen(elements);
                int blue = colorModel.getBlue(elements);
                int average = (red + green + blue) / 3;
                result[x][y] = (byte)average;
            }
        }
        return result;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeInt((int)this.edgeThresholdSlider.discreteValue());
        output.writeInt((int)this.edgeDistanceSlider.discreteValue());
        output.writeBoolean(this.invertBooleanButton.checked());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.edgeThresholdSlider.setFromDiscreteValue(input.readInt());
        this.edgeDistanceSlider.setFromDiscreteValue(input.readInt());
        this.invertBooleanButton.checked(input.readBoolean());
    }
}

