/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.BookBuilder;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.options.BookOption;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.jetbrains.annotations.Nullable;

public class ImagetextBookPageTab
implements IImagetextTab,
IMemento {
    private ContextMenuButton bookPageButton;
    private BookOption bookMode;

    @Override
    public void build(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        ImagetextData modifiedData = new ImagetextData(data.image(), this.maxImageWidthFrom(algorithm.pixelExample()), 15, data.smoothRescaling(), data.similarityThreshold());
        logic.buildImagetext(algorithm, modifiedData);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        BookBuilder bookBuilder = this.bookMode.getBookBuilder();
        bookBuilder.addPage(logic.mergeText());
        ItemUtils.give(bookBuilder.get());
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.bookPageButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "bookPageMode");
        this.bookPageButton.setContextMenuOptions(dropdownComponent -> {
            for (BookOption option : BookOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateBookPage(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBookPage(BookOption.ADD_PAGE);
    }

    private void updateBookPage(BookOption bookMode) {
        this.bookMode = bookMode;
        this.bookPageButton.method_25355((class_2561)class_2561.method_43471((String)this.bookMode.getTranslationKey()));
    }

    @Override
    public String getId() {
        return "bookPage";
    }

    private int maxImageWidthFrom(@Nullable String characters) {
        if (characters == null) {
            characters = "\u2588";
        }
        int maxTextWidth = 113;
        int width = 0;
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (characters.length() == 1) {
            width = maxTextWidth / textRenderer.method_1727(characters);
        } else {
            Object message = "";
            int length = characters.length();
            do {
                message = (String)message + characters.charAt(width % length);
                ++width;
            } while (textRenderer.method_1727((String)message) < maxTextWidth);
        }
        return width;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.bookMode);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.updateBookPage((BookOption)input.readObject());
    }
}

