/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.ContainerBuilder;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.builders.SignBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTooltip;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLine;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.TextUtils;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2508;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4719;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7713;
import net.minecraft.class_7717;
import net.minecraft.class_7923;

public class ImagetextSignTab
implements IImagetextTab,
IImagetextTooltip,
IMemento {
    private static final String BASE_ITEMS_TRANSLATION_KEY = "fzmm.item.imagetext.sign.";
    private ContextMenuButton signTypeButton;
    private SmallCheckboxComponent isHangingSignButton;
    private class_4719 woodType;

    @Override
    public void build(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.buildImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        List<class_1799> signContainers = ContainerBuilder.builder().containerItem(class_1802.field_8627).maxItemByContainer(27).addAll(this.signItemsOf(logic)).getAsList();
        class_1799 signMainContainer = ContainerBuilder.builder().containerItem(class_1802.field_8451).maxItemByContainer(27).add(DisplayBuilder.builder().item(class_1802.field_8407).setName((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.sign.details.name", (Object[])new Object[]{this.horizontalSignsOf(logic.text()), this.verticalSignsOf(logic.height())}), color).get()).addAll(signContainers).getAsList().get(0);
        signMainContainer = DisplayBuilder.of(signMainContainer).setName((class_2561)class_2561.method_43471((String)"fzmm.item.imagetext.sign.container.name"), color).addLore((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.sign.container.lore.1", (Object[])new Object[]{logic.width(), logic.height()}), color).get();
        ItemUtils.give(signMainContainer);
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.signTypeButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "signType");
        this.signTypeButton.setContextMenuOptions(dropdownComponent -> {
            List<class_4719> optionList = class_4719.method_24026().sorted(Comparator.comparing(woodType1 -> this.getSignText((class_4719)woodType1).getString())).toList();
            for (class_4719 option : optionList) {
                dropdownComponent.button(this.getSignText(option), dropdownButton -> {
                    this.updateSignType(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateSignType(class_4719.field_21676);
        this.isHangingSignButton = rootComponent.childByIdOrThrow(SmallCheckboxComponent.class, "isHangingSign-checkbox");
        this.isHangingSignButton.checked(false);
    }

    private void updateSignType(class_4719 option) {
        this.woodType = option;
        this.signTypeButton.method_25355(this.getSignText(this.woodType));
    }

    @Override
    public String getId() {
        return "sign";
    }

    private class_2561 getSignText(class_4719 type) {
        return class_2561.method_43471((String)("block.minecraft." + type.comp_1299() + "_sign"));
    }

    public List<class_1799> signItemsOf(ImagetextLogic logic) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        ArrayList<SignBuilder> signBuilders = new ArrayList<SignBuilder>();
        List<class_2561> imagetext = logic.text();
        int height = logic.height();
        int horizontalSigns = this.horizontalSignsOf(imagetext);
        int verticalSigns = this.verticalSignsOf(height);
        int maxTextWidth = this.getMaxTextWidth();
        class_1792 item = this.getItem();
        class_5481[][] imagetextWrapped = new class_5481[imagetext.size()][horizontalSigns];
        for (int i = 0; i != imagetext.size(); ++i) {
            imagetextWrapped[i] = (class_5481[])textRenderer.method_1728((class_5348)imagetext.get(i), maxTextWidth).toArray(class_5481[]::new);
        }
        for (int y = 0; y != verticalSigns; ++y) {
            for (int x = 0; x != horizontalSigns; ++x) {
                int index = y * horizontalSigns + x;
                if (signBuilders.size() <= index) {
                    signBuilders.add(SignBuilder.builder().item(item));
                }
                this.addSignLines(x, y, (SignBuilder)signBuilders.get(index), imagetextWrapped, maxTextWidth);
            }
        }
        return this.formatSignItems(signBuilders, horizontalSigns);
    }

    public int horizontalSignsOf(List<class_2561> imagetext) {
        if (imagetext.isEmpty()) {
            return 0;
        }
        int maxWidth = this.getMaxTextWidth() - 1;
        return class_310.method_1551().field_1772.method_1728((class_5348)imagetext.get(0), maxWidth).size();
    }

    public int verticalSignsOf(int height) {
        if (height <= 4) {
            return 1;
        }
        return (int)Math.floor((double)height / 4.0);
    }

    public void addSignLines(int x, int y, SignBuilder builder, class_5481[][] imagetextWrapped, int maxTextWidth) {
        for (int i = 0; i != 4; ++i) {
            int index = y * 4 + i;
            if (index >= imagetextWrapped.length || x >= imagetextWrapped[index].length) continue;
            builder.addFrontLine(this.orderedTextToText(imagetextWrapped[index][x]), maxTextWidth);
        }
    }

    private class_2561 orderedTextToText(class_5481 text) {
        ImagetextLine line = new ImagetextLine(0.0);
        StringBuilder characters = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            characters.appendCodePoint(codePoint);
            return true;
        });
        line.characters((String[])TextUtils.splitMessage(characters.toString()).toArray(String[]::new));
        text.accept((index, characterStyle, c) -> {
            if (characterStyle.method_10973() != null) {
                line.add(characterStyle.method_10973().method_27716());
            }
            return true;
        });
        return line.build();
    }

    public List<class_1799> formatSignItems(List<SignBuilder> signBuilders, int signsPerLine) {
        ArrayList<class_1799> signStackList = new ArrayList<class_1799>();
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        for (int i = 0; i != signBuilders.size(); ++i) {
            class_1799 sign = signBuilders.get(i).wax().get();
            sign = DisplayBuilder.of(sign).setName(String.format("X: %d - Y: %d", i % signsPerLine + 1, i / signsPerLine + 1), color).get();
            signStackList.add(sign);
        }
        return signStackList;
    }

    public int getMaxTextWidth() {
        class_7717 signBlockEntity = this.isHangingSignButton.checked() ? new class_7717(new class_2338(0, 0, 0), class_2246.field_40262.method_9564()) : new class_2625(new class_2338(0, 0, 0), class_2246.field_10121.method_9564());
        return signBlockEntity.method_45470();
    }

    public class_1792 getItem() {
        boolean isHangingSign = this.isHangingSignButton.checked();
        for (class_2248 block : class_7923.field_41175.method_10220().toList()) {
            class_2508 signBlock;
            class_7713 hangingSignBlock;
            if (isHangingSign && block instanceof class_7713 && (hangingSignBlock = (class_7713)block).method_24025() == this.woodType) {
                return hangingSignBlock.method_8389();
            }
            if (isHangingSign || !(block instanceof class_2508) || (signBlock = (class_2508)block).method_24025() != this.woodType) continue;
            return signBlock.method_8389();
        }
        return class_1802.field_8788;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.woodType.comp_1299());
        output.writeBoolean(this.isHangingSignButton.checked());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        String woodName = (String)input.readObject();
        class_4719 woodType = class_4719.method_24026().filter(woodType1 -> woodType1.comp_1299().equals(woodName)).findFirst().orElse(class_4719.field_21676);
        this.updateSignType(woodType);
        this.isHangingSignButton.checked(input.readBoolean());
    }

    @Override
    public class_2561 getTooltip(ImagetextLogic logic) {
        int horizontalSigns = this.horizontalSignsOf(logic.text());
        int verticalSigns = this.verticalSignsOf(logic.height());
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.sign.tooltip", (Object[])new Object[]{horizontalSigns, verticalSigns});
    }
}

