/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.utils.select_item;

import com.google.common.collect.ImmutableList;
import fzmm.zailer.me.client.FzmmItemGroup;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.utils.select_item.RequestedItem;
import fzmm.zailer.me.client.logic.history.FzmmHistory;
import fzmm.zailer.me.utils.InventoryUtils;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;

public class SelectItemScreen
extends BaseFzmmScreen {
    private final HashMap<RequestedItem, ItemComponent> requestedItems = new HashMap();
    private final RequestedItem selectedRequestedItem;
    private final List<ItemComponent> itemComponentList = new ArrayList<ItemComponent>();
    private FlowLayout requestedItemsLayout;
    private FlowLayout itemLayout;
    private class_342 searchField;
    private List<ButtonComponent> sourceButtons;
    private ButtonComponent executeButton;
    private boolean executed = false;

    public SelectItemScreen(@Nullable class_437 parent, RequestedItem requestedItem) {
        this(parent, List.of(requestedItem));
    }

    public SelectItemScreen(@Nullable class_437 parent, List<RequestedItem> requestedItems) {
        super("utils/select_item", "selectItem", parent);
        for (RequestedItem requestedItem : requestedItems) {
            this.requestedItems.put(requestedItem, EComponents.item(class_1799.field_8037));
        }
        this.selectedRequestedItem = requestedItems.get(0);
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        this.requestedItemsLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "requested-items-list");
        this.itemLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "item-layout");
        this.searchField = TextBoxRow.setup(rootComponent, "item-search", "", 255, str -> this.applyFilter());
        this.searchField.horizontalSizing(Sizing.fill((int)50));
        this.setupSourceButtons(rootComponent);
        this.addRequestedItemButtons();
        this.executeButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "execute-button");
        this.executeButton.active(this.canExecute());
        this.executeButton.onPress(buttonComponent -> {
            this.execute(false);
            this.method_25419();
        });
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.searchField, Component.FocusSource.MOUSE_CLICK);
    }

    private void setupSourceButtons(EFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        ButtonComponent inventoryButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "inventory-button");
        inventoryButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(inventoryButton.id());
            this.addItemCallback(InventoryUtils.getCombinedInventory(), true);
        });
        ButtonComponent defaultButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "default-button");
        defaultButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(defaultButton.id());
            this.addItemCallback(this.selectedRequestedItem.defaultItems(), false);
        });
        ButtonComponent historyButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "history-button");
        historyButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(historyButton.id());
            this.addItemCallback(FzmmHistory.getAllItems(), true);
        });
        FzmmItemGroup.populateItemGroups();
        ButtonComponent allButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "all-button");
        allButton.onPress(buttonComponent -> {
            this.sourceButtonsClicked(allButton.id());
            LinkedHashSet<class_1799> stackList = new LinkedHashSet<class_1799>(InventoryUtils.getCombinedInventory());
            for (class_1761 itemGroup : class_7706.method_47341()) {
                stackList.addAll(itemGroup.method_47313());
            }
            this.addItemCallback(stackList, false);
        });
        this.sourceButtons = ImmutableList.of((Object)inventoryButton, (Object)defaultButton, (Object)historyButton, (Object)allButton);
        inventoryButton.method_25306();
        if (this.itemComponentList.isEmpty()) {
            defaultButton.method_25306();
        }
    }

    private void addItemCallback(Collection<class_1799> stackList, boolean filter) {
        ArrayList<ItemComponent> itemComponents = new ArrayList<ItemComponent>();
        Predicate<class_1799> stackPredicate = this.selectedRequestedItem.predicate();
        for (class_1799 stack : stackList) {
            if (filter && !stackPredicate.test(stack) || stack.method_7960()) continue;
            itemComponents.add(this.getItemCallback(stack));
        }
        this.itemComponentList.addAll(itemComponents);
        this.applyFilter();
    }

    private ItemComponent getItemCallback(class_1799 stack) {
        assert (this.field_22787 != null);
        class_1799 processedStack = ItemUtils.process(stack);
        ItemComponent itemComponent = EComponents.item(processedStack).setTooltipFromStack(true);
        itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectedRequestedItem.setStack(processedStack);
            this.requestedItems.get(this.selectedRequestedItem).stack(processedStack);
            this.executeButton.field_22763 = this.canExecute();
            return true;
        });
        return itemComponent;
    }

    private void sourceButtonsClicked(String id) {
        this.itemComponentList.clear();
        for (ButtonComponent sourceButton : this.sourceButtons) {
            sourceButton.field_22763 = !id.equals(sourceButton.id());
        }
    }

    private void addRequestedItemButtons() {
        List entries = this.requestedItems.keySet().stream().toList();
        ArrayList<Component> requestedItemsEntries = new ArrayList<Component>();
        for (int i = 0; i != entries.size(); ++i) {
            RequestedItem entry = (RequestedItem)entries.get(i);
            requestedItemsEntries.add(this.addRequestedItemButton(entry, entry.stack().orElse(class_1799.field_8037), i));
        }
        this.requestedItemsLayout.children(requestedItemsEntries);
    }

    private Component addRequestedItemButton(RequestedItem requestedItem, class_1799 stack, int index) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", String.valueOf(index));
        FlowLayout requestedItemLayout = (FlowLayout)this.getModel().expandTemplate(FlowLayout.class, "requested-item", parameters);
        this.requestedItems.put(requestedItem, this.getRequestedItemPreview(requestedItemLayout, stack, index));
        LabelComponent labelComponent = (LabelComponent)requestedItemLayout.childById(LabelComponent.class, index + "-requested-item-label");
        if (labelComponent != null) {
            labelComponent.text(requestedItem.title());
        }
        return requestedItemLayout;
    }

    private ItemComponent getRequestedItemPreview(FlowLayout layout, class_1799 stack, int index) {
        ItemComponent itemComponent = (ItemComponent)layout.childById(ItemComponent.class, index + "-requested-item-item");
        if (itemComponent != null) {
            assert (this.field_22787 != null);
            itemComponent.stack(stack);
            itemComponent.tooltip((Collection)stack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)));
        }
        return itemComponent;
    }

    private void applyFilter() {
        if (this.searchField == null) {
            return;
        }
        this.itemLayout.clearChildren();
        ArrayList<ItemComponent> resultList = new ArrayList<ItemComponent>();
        String search = this.searchField.method_1882().toLowerCase();
        for (ItemComponent itemComponent : this.itemComponentList) {
            if (!itemComponent.stack().method_7964().getString().toLowerCase().contains(search)) continue;
            resultList.add(itemComponent);
        }
        this.itemLayout.children(resultList);
    }

    private boolean canExecute() {
        for (RequestedItem requestedItem : this.requestedItems.keySet()) {
            if (requestedItem.canExecute()) continue;
            return false;
        }
        return true;
    }

    private void execute(boolean replaceWithEmpty) {
        this.executed = true;
        for (RequestedItem requestedItem : this.requestedItems.keySet()) {
            if (!replaceWithEmpty && requestedItem.canExecute()) {
                requestedItem.execute();
                continue;
            }
            requestedItem.execute(class_1799.field_8037);
        }
    }

    @Override
    public void method_25432() {
        super.method_25432();
        if (!this.executed) {
            this.execute(true);
        }
    }
}

