/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.InternalModels;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ColorParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ModelParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ParameterList;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ResettableModelParameter;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelConditionStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelCopyStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelDeleteStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelFillColorStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelFunctionStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.ModelToggleOffsetStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.select.ModelSelectColorStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.select.ModelSelectDestinationStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.select.ModelSelectTextureStep;
import fzmm.zailer.me.client.logic.head_generator.texture.HeadTextureEntry;
import fzmm.zailer.me.utils.ImageUtils;
import io.wispforest.owo.ui.core.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5250;

public class HeadResourcesLoader
implements class_4013,
IdentifiableResourceReloadListener {
    private static ImmutableList<AbstractHeadEntry> LOADED_RESOURCES = ImmutableList.builder().build();
    private static ImmutableMap<String, BufferedImage> LOADED_MODEL_TEXTURES = ImmutableMap.builder().build();
    public static final String HEADS_TEXTURES_FOLDER = "textures/heads";
    public static final String FZMM_MODELS_FOLDER = "fzmm_models";
    public static final String INTERNAL_FOLDER = "internal";
    public static final String INTERNAL_MODELS_FOLDER = "fzmm_models/internal";

    public static ImmutableList<AbstractHeadEntry> getAllLoaded() {
        return LOADED_RESOURCES;
    }

    public static ImmutableList<AbstractHeadEntry> getLoaded() {
        return (ImmutableList)LOADED_RESOURCES.stream().filter(entry -> {
            HeadModelEntry modelEntry;
            return !(entry instanceof HeadModelEntry) || !(modelEntry = (HeadModelEntry)entry).isInternal();
        }).collect(ImmutableList.toImmutableList());
    }

    public static Optional<AbstractHeadEntry> getByPath(String id) {
        for (AbstractHeadEntry entry : LOADED_RESOURCES) {
            if (!entry.getPath().equals(id)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public static Optional<BufferedImage> getModelTexture(String path) {
        return Optional.ofNullable((BufferedImage)LOADED_MODEL_TEXTURES.get((Object)path));
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"fzmm", (String)"head-resources-loader");
    }

    public void method_14491(class_3300 manager) {
        try {
            ArrayList<AbstractHeadEntry> builder = new ArrayList<AbstractHeadEntry>();
            builder.addAll(HeadResourcesLoader.loadHeadsModels(manager, INTERNAL_MODELS_FOLDER, true));
            builder.addAll(HeadResourcesLoader.loadHeadsModels(manager, "fzmm_models/heads", false));
            builder.addAll(HeadResourcesLoader.loadHeadsTextures(manager));
            builder.sort(Comparator.comparing(AbstractHeadEntry::isFirstResult).reversed().thenComparing(AbstractHeadEntry::getPath));
            LOADED_RESOURCES = ImmutableList.copyOf(builder);
            InternalModels.reload();
            List<class_2960> modelTextureList = HeadResourcesLoader.getModelTextureList(LOADED_RESOURCES);
            LOADED_MODEL_TEXTURES = HeadResourcesLoader.loadModelsTextures(manager, modelTextureList);
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[HeadResourcesLoader] Error reloading resources", (Throwable)e);
        }
        this.validate();
    }

    public void validate() {
        int previousValidResources = -1;
        while (previousValidResources != LOADED_RESOURCES.size()) {
            ArrayList<AbstractHeadEntry> builder = new ArrayList<AbstractHeadEntry>();
            for (AbstractHeadEntry entry : LOADED_RESOURCES) {
                try {
                    if (entry instanceof HeadModelEntry) {
                        HeadModelEntry modelEntry = (HeadModelEntry)entry;
                        if (modelEntry.validate()) {
                            builder.add(modelEntry);
                            continue;
                        }
                        FzmmClient.LOGGER.warn("[HeadResourcesLoader] '{}' is not valid", (Object)modelEntry.getPath());
                        continue;
                    }
                    builder.add(entry);
                }
                catch (Exception e) {
                    FzmmClient.LOGGER.error("[HeadResourcesLoader] Error validating '{}'", (Object)entry.getPath(), (Object)e);
                    HeadResourcesLoader.addChatMessageError(e, entry.getPath());
                }
            }
            previousValidResources = LOADED_RESOURCES.size();
            LOADED_RESOURCES = ImmutableList.copyOf(builder);
        }
    }

    private static Set<HeadTextureEntry> loadHeadsTextures(class_3300 manager) {
        HashSet<HeadTextureEntry> entries = new HashSet<HeadTextureEntry>();
        manager.method_14488(HEADS_TEXTURES_FOLDER, identifier -> identifier.method_12832().endsWith(".png")).forEach((identifier, resource) -> {
            InputStream inputStream = null;
            try {
                inputStream = resource.method_14482();
                BufferedImage bufferedImage = ImageUtils.withType(ImageIO.read(inputStream), 2);
                String path = identifier.method_12832();
                String fileName = path.substring(HEADS_TEXTURES_FOLDER.length() + 1, path.length() - ".png".length());
                entries.add(new HeadTextureEntry(bufferedImage, fileName));
            }
            catch (IOException e) {
                FzmmClient.LOGGER.error("[HeadResourcesLoader] Error loading head generator texture", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        FzmmClient.LOGGER.error("[HeadResourcesLoader] Error closing texture input stream", (Throwable)e);
                    }
                }
            }
        });
        return entries;
    }

    private static ImmutableMap<String, BufferedImage> loadModelsTextures(class_3300 manager, List<class_2960> modelTextureList) {
        ImmutableMap.Builder entries = new ImmutableMap.Builder();
        for (class_2960 modelTextureIdentifier : modelTextureList) {
            manager.method_14486(modelTextureIdentifier).ifPresentOrElse(resource -> {
                InputStream inputStream = null;
                try {
                    inputStream = resource.method_14482();
                    BufferedImage bufferedImage = ImageUtils.withType(ImageIO.read(inputStream), 2);
                    entries.put((Object)modelTextureIdentifier.toString(), (Object)bufferedImage);
                }
                catch (IOException e) {
                    FzmmClient.LOGGER.error("[HeadResourcesLoader] Error loading model texture", (Throwable)e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            FzmmClient.LOGGER.error("[HeadResourcesLoader] Error closing texture input stream", (Throwable)e);
                        }
                    }
                }
            }, () -> FzmmClient.LOGGER.warn("[HeadResourcesLoader] Error loading model texture: {}", (Object)modelTextureIdentifier.toString()));
        }
        return entries.build();
    }

    private static List<class_2960> getModelTextureList(List<AbstractHeadEntry> builder) {
        ArrayList<class_2960> result = new ArrayList<class_2960>();
        for (AbstractHeadEntry entry : builder) {
            if (!(entry instanceof HeadModelEntry)) continue;
            HeadModelEntry modelEntry = (HeadModelEntry)entry;
            try {
                HeadResourcesLoader.addTexturePathsFromModelEntry(result, modelEntry);
            }
            catch (IllegalArgumentException ignored) {
                FzmmClient.LOGGER.error("[HeadResourcesLoader] Error loading textures of model '{}'", (Object)modelEntry.getKey());
            }
        }
        return result.stream().distinct().toList();
    }

    private static void addTexturePathsFromModelEntry(List<class_2960> result, HeadModelEntry modelEntry) {
        List<IParameterEntry<BufferedImage>> parameterList = modelEntry.getNestedTextureParameters().parameterList();
        for (IParameterEntry<BufferedImage> parameter : parameterList) {
            HeadResourcesLoader.addTexturePathFromParameter(result, parameter);
        }
    }

    private static void addTexturePathFromParameter(List<class_2960> result, IParameterEntry<BufferedImage> parameter) {
        if (!(parameter instanceof ResettableModelParameter)) {
            return;
        }
        ResettableModelParameter resettableParam = (ResettableModelParameter)parameter;
        String defaultValue = resettableParam.getDefaultValue();
        if (defaultValue == null) {
            return;
        }
        class_2960 value = class_2960.method_12829((String)defaultValue);
        if (value != null) {
            result.add(value);
        }
    }

    private static Set<HeadModelEntry> loadHeadsModels(class_3300 manager, String path, boolean internal) {
        HashSet<HeadModelEntry> entries = new HashSet<HeadModelEntry>();
        manager.method_14488(path, identifier -> identifier.method_12832().endsWith(".json")).forEach((identifier, resource) -> {
            InputStream inputStream = null;
            try {
                inputStream = resource.method_14482();
                entries.add(HeadResourcesLoader.getHeadModel(path, identifier, inputStream));
            }
            catch (Exception e) {
                FzmmClient.LOGGER.error("[HeadResourcesLoader] Error loading head generator model: {}", (Object)identifier.method_12832(), (Object)e);
                HeadResourcesLoader.addChatMessageError(e, identifier.method_12832());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        FzmmClient.LOGGER.error("[HeadResourcesLoader] Error closing model input stream", (Throwable)e);
                    }
                }
            }
        });
        for (HeadModelEntry entry : entries) {
            entry.isInternal(internal);
        }
        return entries;
    }

    public static HeadModelEntry getHeadModel(String basePath, class_2960 identifier, InputStream inputStream) {
        String path = identifier.method_12832();
        String[] folders = (path = path.substring(0, path.length() - ".json".length())).split("/");
        path = folders.length > 1 ? folders[folders.length - 2] + "/" + folders[folders.length - 1] : basePath;
        JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
        Optional<ParameterList<Object>> textures = HeadResourcesLoader.getParameterList(jsonObject, "textures", HeadResourcesLoader::textureParser);
        Optional<ParameterList<Object>> colors = HeadResourcesLoader.getParameterList(jsonObject, "colors", HeadResourcesLoader::colorParser);
        Optional<ParameterList<Object>> offsets = HeadResourcesLoader.getParameterList(jsonObject, "offsets", HeadResourcesLoader::offsetParser);
        boolean isPaintableModel = jsonObject.has("paintable") && jsonObject.get("paintable").getAsBoolean();
        boolean isEditingSkinBody = jsonObject.has("is_editing_skin_body") && jsonObject.get("is_editing_skin_body").getAsBoolean();
        boolean isFirstResult = jsonObject.has("first_result") && jsonObject.get("first_result").getAsBoolean();
        boolean isInvertedLeftAndRight = jsonObject.has("inverted_left_and_right") && jsonObject.get("inverted_left_and_right").getAsBoolean();
        JsonArray stepsArray = HeadResourcesLoader.get(jsonObject, "steps").getAsJsonArray();
        ArrayList<IModelStep> steps = new ArrayList<IModelStep>();
        for (JsonElement element : stepsArray) {
            JsonObject stepObject = element.getAsJsonObject();
            steps.add(HeadResourcesLoader.parseStep(stepObject));
        }
        HeadModelEntry entry = new HeadModelEntry(path, steps, textures.orElse(null), colors.orElse(null), offsets.orElse(null));
        entry.isPaintable(isPaintableModel);
        entry.isEditingSkinBody(isEditingSkinBody);
        entry.isFirstResult(isFirstResult);
        entry.isInvertedLeftAndRight(isInvertedLeftAndRight);
        return entry;
    }

    public static JsonElement get(JsonObject jsonObject, String key) throws IllegalArgumentException {
        if (jsonObject.has(key)) {
            return jsonObject.get(key);
        }
        throw new IllegalArgumentException(String.format("[HeadResourcesLoader] Missing key: '%s', JSON object: %s", key, jsonObject));
    }

    public static IModelStep parseStep(JsonObject stepObject) {
        String id;
        return switch (id = HeadResourcesLoader.get(stepObject, "type").getAsString()) {
            case "copy" -> ModelCopyStep.parse(stepObject);
            case "delete" -> ModelDeleteStep.parse(stepObject);
            case "fill_color" -> ModelFillColorStep.parse(stepObject);
            case "select_color" -> ModelSelectColorStep.parse(stepObject);
            case "select_texture" -> ModelSelectTextureStep.parse(stepObject);
            case "toggle_offset" -> ModelToggleOffsetStep.parse(stepObject);
            case "select_destination" -> ModelSelectDestinationStep.parse(stepObject);
            case "function" -> ModelFunctionStep.parse(stepObject);
            case "condition" -> ModelConditionStep.parse(stepObject);
            default -> data -> FzmmClient.LOGGER.warn("[HeadResourcesLoader] Unknown model step type: {}", (Object)id);
        };
    }

    public static <T> Optional<ParameterList<T>> getParameterList(JsonObject jsonObject, String key, Function<JsonObject, IParameterEntry<T>> elementParser) {
        ParameterList<T> result = new ParameterList<T>();
        if (!jsonObject.has(key)) {
            return Optional.empty();
        }
        JsonArray texturesArray = jsonObject.get(key).getAsJsonArray();
        for (JsonElement textureElement : texturesArray) {
            JsonObject textureObject = textureElement.getAsJsonObject();
            result.put(elementParser.apply(textureObject));
        }
        return Optional.of(result);
    }

    public static IParameterEntry<BufferedImage> textureParser(JsonObject jsonObject) {
        String id = HeadResourcesLoader.get(jsonObject, "id").getAsString();
        boolean requested = !jsonObject.has("requested") || jsonObject.get("requested").getAsBoolean();
        String defaultValue = jsonObject.has("path") ? jsonObject.get("path").getAsString() : null;
        return new ResettableModelParameter<Object>(id, null, defaultValue, requested);
    }

    public static IParameterEntry<ColorParameter> colorParser(JsonObject jsonObject) {
        String id = HeadResourcesLoader.get(jsonObject, "id").getAsString();
        boolean requested = !jsonObject.has("requested") || jsonObject.get("requested").getAsBoolean();
        Color color = Color.WHITE;
        if (jsonObject.has("color_hex")) {
            String colorHex = jsonObject.get("color_hex").getAsString();
            color = HeadResourcesLoader.parseColor(colorHex);
        }
        boolean hasAlpha = jsonObject.has("has_alpha") && jsonObject.get("has_alpha").getAsBoolean();
        return new ModelParameter<ColorParameter>(id, new ColorParameter(color, hasAlpha), requested);
    }

    public static Color parseColor(String colorHex) {
        if (!colorHex.startsWith("#")) {
            throw new IllegalArgumentException(String.format("[HeadResourcesLoader] Missing '#' in color hex: %s", colorHex));
        }
        colorHex = colorHex.substring(1);
        int color = Integer.parseUnsignedInt(colorHex, 16);
        return colorHex.length() == 8 ? Color.ofArgb((int)color) : Color.ofRgb((int)color);
    }

    public static IParameterEntry<OffsetParameter> offsetParser(JsonObject jsonObject) {
        String id = HeadResourcesLoader.get(jsonObject, "id").getAsString();
        boolean requested = !jsonObject.has("requested") || jsonObject.get("requested").getAsBoolean();
        byte value = jsonObject.has("value") ? jsonObject.get("value").getAsByte() : (byte)0;
        byte minValue = jsonObject.has("min_value") ? jsonObject.get("min_value").getAsByte() : (byte)0;
        byte maxValue = jsonObject.has("max_value") ? (byte)jsonObject.get("max_value").getAsByte() : (byte)8;
        boolean isXAxis = jsonObject.has("axis") && jsonObject.get("axis").getAsString().equalsIgnoreCase("X");
        boolean enabled = jsonObject.has("enabled") && jsonObject.get("enabled").getAsBoolean();
        return new ModelParameter<OffsetParameter>(id, new OffsetParameter(value, minValue, maxValue, isXAxis, enabled), requested);
    }

    private static void addChatMessageError(Exception e, String path) {
        if (class_310.method_1551().field_1724 != null) {
            class_5250 message = class_2561.method_43469((String)"fzmm.gui.headGenerator.model.error.loadingModel", (Object[])new Object[]{path}).method_10862(class_2583.field_24360.method_36139(4689479).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)e.getMessage()))));
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)message);
        }
    }
}

