/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model.steps;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.ModelData;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import fzmm.zailer.me.client.logic.head_generator.model.steps.conditions.ConditionIsAlpha;
import fzmm.zailer.me.client.logic.head_generator.model.steps.conditions.ConditionIsPixel;
import fzmm.zailer.me.client.logic.head_generator.model.steps.conditions.ConditionIsSlimModel;
import fzmm.zailer.me.client.logic.head_generator.model.steps.conditions.ICondition;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModelConditionStep
implements IModelStep {
    private final ICondition condition;
    private final List<IModelStep> ifTrueList;
    private final List<IModelStep> ifFalseList;

    public ModelConditionStep(ICondition condition, @Nullable List<IModelStep> ifTrueList, @Nullable List<IModelStep> ifFalseList) {
        this.condition = condition;
        this.ifTrueList = ifTrueList;
        this.ifFalseList = ifFalseList;
    }

    @Override
    public void apply(ModelData data) {
        boolean conditionResult = this.condition.predicate(data);
        List<Object> trueSteps = this.ifTrueList == null ? new ArrayList() : this.ifTrueList;
        List<Object> falseSteps = this.ifFalseList == null ? new ArrayList() : this.ifFalseList;
        for (IModelStep iModelStep : conditionResult ? trueSteps : falseSteps) {
            iModelStep.apply(data);
        }
    }

    @Override
    public boolean validate() throws IllegalArgumentException {
        if (this.ifFalseList != null) {
            for (IModelStep step : this.ifFalseList) {
                if (step.validate()) continue;
                return false;
            }
        }
        if (this.ifTrueList != null) {
            for (IModelStep step : this.ifTrueList) {
                if (step.validate()) continue;
                return false;
            }
        }
        return true;
    }

    public static ModelConditionStep parse(JsonObject jsonObject) {
        JsonObject conditionArguments;
        String conditionId = HeadResourcesLoader.get(jsonObject, "condition").getAsString();
        JsonArray ifTrueJson = jsonObject.has("if_true") ? jsonObject.get("if_true").getAsJsonArray() : null;
        JsonArray ifFalseJson = jsonObject.has("if_false") ? jsonObject.get("if_false").getAsJsonArray() : null;
        JsonObject jsonObject2 = conditionArguments = jsonObject.has("arguments") ? jsonObject.get("arguments").getAsJsonObject() : null;
        if (ifTrueJson == null && ifFalseJson == null) {
            throw new IllegalArgumentException("[ModelConditionStep] Must contain either 'if_true' and/or 'if_false'");
        }
        ArrayList<IModelStep> ifTrueList = null;
        ArrayList<IModelStep> ifFalseList = null;
        if (ifTrueJson != null) {
            ifTrueList = new ArrayList<IModelStep>();
            for (JsonElement element : ifTrueJson) {
                ifTrueList.add(HeadResourcesLoader.parseStep(element.getAsJsonObject()));
            }
        }
        if (ifFalseJson != null) {
            ifFalseList = new ArrayList<IModelStep>();
            for (JsonElement element : ifFalseJson) {
                ifFalseList.add(HeadResourcesLoader.parseStep(element.getAsJsonObject()));
            }
        }
        ICondition condition = switch (conditionId) {
            case "is_slim_model" -> new ConditionIsSlimModel();
            case "is_pixel" -> new ConditionIsPixel(conditionArguments);
            case "is_alpha" -> new ConditionIsAlpha(conditionArguments);
            default -> throw new IllegalArgumentException(String.format("[ModelConditionStep] Unknown condition type: %s", conditionId));
        };
        return new ModelConditionStep(condition, ifTrueList, ifFalseList);
    }
}

