/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.texture;

import fzmm.zailer.me.client.gui.head_generator.options.ISkinPreEdit;
import fzmm.zailer.me.client.gui.head_generator.options.SkinPreEditOption;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.InternalModels;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.SkinPart;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class HeadTextureEntry
extends AbstractHeadEntry {
    private final BufferedImage headSkin;
    private final boolean isEditingSkinBody;

    public HeadTextureEntry(BufferedImage headSkin, String path) {
        super(path);
        this.headSkin = headSkin;
        this.isEditingSkinBody = this.calculateIsEditingSkinBody();
    }

    @Override
    public BufferedImage getHeadSkin(BufferedImage baseSkin, boolean hasUnusedPixels) {
        ISkinPreEdit noneEdit = SkinPreEditOption.NONE.getPreEdit();
        BufferedImage result = new BufferedImage(64, 64, 2);
        Graphics2D graphics = result.createGraphics();
        noneEdit.apply(graphics, baseSkin);
        if (this.isEditingSkinBody() && ImageUtils.isSlimSimpleCheck(baseSkin) != ImageUtils.isSlimFullCheck(this.headSkin)) {
            HeadModelEntry formatUpdater = ImageUtils.isSlimSimpleCheck(baseSkin) ? InternalModels.WIDE_TO_SLIM : InternalModels.SLIM_TO_WIDE;
            BufferedImage adaptedHeadSkin = formatUpdater.getHeadSkin(this.headSkin, false);
            noneEdit.apply(graphics, adaptedHeadSkin);
            adaptedHeadSkin.flush();
        } else {
            noneEdit.apply(graphics, this.headSkin);
        }
        if (hasUnusedPixels) {
            ImageUtils.copyUnusedPixels(baseSkin, graphics);
        }
        graphics.dispose();
        return result;
    }

    @Override
    public String getCategoryId() {
        return "texture";
    }

    @Override
    public boolean isEditingSkinBody() {
        return this.isEditingSkinBody;
    }

    @Override
    public boolean isFirstResult() {
        return false;
    }

    private boolean calculateIsEditingSkinBody() {
        if (this.headSkin.getWidth() != 64 || this.headSkin.getHeight() != 64) {
            return false;
        }
        for (SkinPart part : SkinPart.BODY_PARTS) {
            byte[][] usedAreas;
            for (byte[] rect : usedAreas = part.usedAreas()) {
                if (!this.calculateIsEditingSkinBody(rect[0], rect[1], rect[2], rect[3])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean calculateIsEditingSkinBody(int x, int y, int x2, int y2) {
        for (int i = x; i < x2; ++i) {
            for (int j = y; j < y2; ++j) {
                if (!ImageUtils.hasPixel(j, i, this.headSkin)) continue;
                return true;
            }
        }
        return false;
    }
}

