/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.HistoryScreen;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.SnackBarBuilder;
import fzmm.zailer.me.client.logic.history.FzmmHistory;
import fzmm.zailer.me.utils.ByteCountDataOutput;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.HeadUtils;
import fzmm.zailer.me.utils.InventoryUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Sizing;
import java.io.DataOutput;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemUtils {
    private static final class_2561 GIVE_ITEM_ERROR = class_2561.method_43471((String)"fzmm.giveItem.error");

    public static class_1799 from(class_1268 hand) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        class_1799 stack = client.field_1724.method_5998(hand);
        return ItemUtils.process(stack);
    }

    public static class_1792 from(String value) {
        return class_7923.field_41178.method_17966(class_2960.method_60654((String)value)).orElse(class_1802.field_20391);
    }

    public static boolean give(class_1799 stack) {
        Optional<ISnackBarComponent> snackBar = ItemUtils.canGive(stack);
        if (snackBar.isPresent()) {
            class_310.method_1551().execute(() -> SnackBarManager.getInstance().remove("give").add((ISnackBarComponent)snackBar.get()));
            return false;
        }
        return ItemUtils.uncheckedGive(stack);
    }

    private static boolean uncheckedGive(class_1799 stack) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        if (FzmmClient.CONFIG.general.giveClientSide()) {
            ItemUtils.updateHandClientSide(stack);
        } else {
            class_1661 playerInventory = client.field_1724.method_31548();
            int slot = playerInventory.method_7395(stack);
            if (class_1661.method_7380((int)slot)) {
                playerInventory.method_61496(slot);
            } else {
                playerInventory.method_65126(stack);
            }
            ItemUtils.updateHand(stack);
        }
        return true;
    }

    public static Optional<ISnackBarComponent> canGive(class_1799 stack) {
        long inventorySize;
        long stackSize;
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        SnackBarBuilder builder = BaseSnackBarComponent.builder("give").title(GIVE_ITEM_ERROR).backgroundColor(EStyles.ALERT_ERROR_COLOR).keepOnLimit().highTimer().startTimer().closeButton().expandDetails();
        if (FzmmClient.CONFIG.general.giveItemSizeLimit() && (stackSize = ItemUtils.getLengthInBytes(stack)) + (inventorySize = InventoryUtils.getSizeInBytes(InventoryUtils.getCombinedInventory())) > 8000000L) {
            FzmmClient.LOGGER.warn("[ItemUtils] An attempt was made to give an item with size of {} bytes (with {} bytes already in inventory)", (Object)stackSize, (Object)inventorySize);
            return Optional.of(builder.details((class_2561)class_2561.method_43469((String)"fzmm.giveItem.exceedLimit", (Object[])new Object[]{ItemUtils.getLengthInKB(stackSize + inventorySize), ItemUtils.getLengthInKB(8000000L)})).button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.configs.icon"), buttonComponent -> {
                client.method_1507((class_437)ConfigScreen.create((ConfigWrapper)FzmmClient.CONFIG, (class_437)client.field_1755));
                snackBar.close();
            })).build());
        }
        FzmmHistory.add(stack);
        if (FzmmClient.CONFIG.general.checkValidCodec() && !ItemUtils.isCodecValid(stack)) {
            FzmmClient.LOGGER.warn("[ItemUtils] An item with an invalid codec was found: {}", (Object)stack.method_57353().toString());
            return Optional.of(builder.details((class_2561)class_2561.method_43471((String)"fzmm.giveItem.codecError")).backgroundColor(EStyles.ALERT_WARNING_COLOR).button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.configs.icon"), buttonComponent -> {
                client.method_1507((class_437)ConfigScreen.create((ConfigWrapper)FzmmClient.CONFIG, (class_437)client.field_1755));
                snackBar.close();
            })).button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.giveItem.codecError.ignore"), buttonComponent -> {
                ItemUtils.uncheckedGive(stack);
                snackBar.close();
            })).sizing(Sizing.fixed((int)250), Sizing.content()).build());
        }
        if (ItemUtils.isNotAllowedToGive()) {
            return Optional.of(builder.details((class_2561)class_2561.method_43471((String)"fzmm.giveItem.notAllowed")).backgroundColor(EStyles.ALERT_ERROR_COLOR).button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.history"), buttonComponent -> {
                FzmmUtils.setScreen(new HistoryScreen(client.field_1755));
                snackBar.close();
            })).build());
        }
        return Optional.empty();
    }

    public static class_1799 process(class_1799 stack) {
        class_1799 stackCopy = stack.method_7972();
        if (FzmmClient.CONFIG.general.removeViaVersionTags()) {
            stackCopy.method_57368(class_9334.field_49628, null, nbtComponent -> {
                if (nbtComponent == null) {
                    return null;
                }
                class_2487 customTag = nbtComponent.method_57461();
                ItemUtils.recursiveRemoveTags(customTag, s -> s.startsWith("VV|Protocol"));
                return customTag.method_10541().isEmpty() ? null : class_9279.method_57456((class_2487)customTag);
            });
        }
        if (FzmmClient.CONFIG.general.minimizeHeadTexturesTag()) {
            stackCopy.method_57368(class_9334.field_49617, null, profileComponent -> {
                if (profileComponent == null) {
                    return null;
                }
                return HeadUtils.minimizeTextures(profileComponent.comp_2413());
            });
        }
        return stackCopy;
    }

    public static void recursiveRemoveTags(class_2487 tags, Predicate<String> keyPredicate) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : tags.method_10541()) {
            if (keyPredicate.test(key)) {
                keysToRemove.add(key);
                continue;
            }
            class_2520 value = tags.method_10580(key);
            if (value instanceof class_2487) {
                class_2487 compound = (class_2487)value;
                ItemUtils.recursiveRemoveTags(compound, keyPredicate);
                continue;
            }
            if (!(value instanceof class_2499)) continue;
            class_2499 list = (class_2499)value;
            for (class_2520 element : list) {
                if (!(element instanceof class_2487)) continue;
                class_2487 compoundElement = (class_2487)element;
                ItemUtils.recursiveRemoveTags(compoundElement, keyPredicate);
            }
        }
        for (String key : keysToRemove) {
            tags.method_10551(key);
        }
    }

    public static boolean isCodecValid(class_1799 stack) {
        try {
            class_2873 packet = new class_2873(0, stack);
            ByteBuf buf = Unpooled.buffer();
            class_9129 registryByteBuf = new class_9129(buf, FzmmUtils.getRegistryManager());
            class_2873.field_48219.encode((Object)registryByteBuf, (Object)packet);
            class_2873.field_48219.decode((Object)registryByteBuf);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static void updateHand(class_1799 stack) {
        class_310 client = class_310.method_1551();
        assert (client.field_1761 != null);
        assert (client.field_1724 != null);
        class_1661 playerInventory = client.field_1724.method_31548();
        ItemUtils.updateHandClientSide(stack);
        client.field_1761.method_2909(stack, 36 + playerInventory.method_67532());
    }

    private static void updateHandClientSide(class_1799 stack) {
        assert (class_310.method_1551().field_1724 != null);
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        inventory.method_5447(inventory.method_67532(), stack);
    }

    public static String getLengthInKB(long length) {
        return new DecimalFormat("#,##0.0").format((float)length / 1024.0f);
    }

    public static long getLengthInBytes(class_1799 stack) {
        ByteCountDataOutput byteCountDataOutput = ByteCountDataOutput.getInstance();
        try {
            class_5455 registryManager = FzmmUtils.getRegistryManager();
            class_2507.method_55324((class_2520)stack.method_57358((class_7225.class_7874)registryManager), (DataOutput)byteCountDataOutput);
        }
        catch (Exception ignored) {
            return 0L;
        }
        long count = byteCountDataOutput.getCount();
        byteCountDataOutput.reset();
        return count;
    }

    public static boolean isNotAllowedToGive() {
        class_310 client = class_310.method_1551();
        if (client.field_1761 == null) {
            return true;
        }
        return !client.field_1761.method_2920().method_8386() && !FzmmClient.CONFIG.general.giveClientSide();
    }
}

