/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class TextUtils {
    public static List<String> splitMessage(String message) {
        int codePoint;
        ArrayList<String> characters = new ArrayList<String>(message.length());
        for (int i = 0; i < message.length(); i += Character.charCount(codePoint)) {
            codePoint = message.codePointAt(i);
            characters.add(new String(Character.toChars(codePoint)));
        }
        return characters;
    }

    public static String removeUnpairedMultibyte(String message) {
        int codePoint;
        if (message.isBlank()) {
            return message;
        }
        StringBuilder builder = new StringBuilder(message.length());
        for (int i = 0; i < message.length(); i += Character.charCount(codePoint)) {
            codePoint = message.codePointAt(i);
            if (Character.charCount(codePoint) != 2 && Character.isSurrogate(message.charAt(i))) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    public static Optional<String> decodeBase64(String encoded) {
        try {
            byte[] decodedValue = Base64.getDecoder().decode(encoded);
            return Optional.of(new String(decodedValue, StandardCharsets.UTF_8));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static String encodeBase64(String message) {
        byte[] messageByte = message.getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(messageByte);
    }
}

