/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils.history;

import fzmm.zailer.me.client.gui.components.extend.component.EButtonComponent;
import fzmm.zailer.me.utils.history.IClipboardState;
import io.wispforest.owo.util.Observable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class HistoryClipboard {
    private final Deque<IClipboardState> undoArray = new ArrayDeque<IClipboardState>();
    private final Deque<IClipboardState> redoArray = new ArrayDeque<IClipboardState>();
    private final EButtonComponent undoButton;
    private final EButtonComponent redoButton;
    private final Observable<IClipboardState> valueObservable;
    private final int maxSize;

    public HistoryClipboard(IClipboardState value, EButtonComponent undoButton, EButtonComponent redoButton, int maxSize) {
        this.undoButton = undoButton;
        this.redoButton = redoButton;
        this.valueObservable = Observable.of((Object)value.copy());
        this.maxSize = maxSize;
        this.setupButton(undoButton, redoButton);
        this.updateButtons();
    }

    private void setupButton(EButtonComponent undoButton, EButtonComponent redoButton) {
        undoButton.onPress(buttonComponent -> this.undo());
        undoButton.tooltip(List.of(class_2561.method_43471((String)"fzmm.gui.button.clipboard.undo"), class_2561.method_43473(), class_2561.method_43471((String)"fzmm.gui.hotkey.single"), class_2561.method_43471((String)"fzmm.gui.hotkey.ctrl").method_27693(" + Z")));
        redoButton.onPress(buttonComponent -> this.redo());
        redoButton.tooltip(List.of(class_2561.method_43471((String)"fzmm.gui.button.clipboard.redo"), class_2561.method_43473(), class_2561.method_43471((String)"fzmm.gui.hotkey.plural"), class_2561.method_43471((String)"fzmm.gui.hotkey.ctrl").method_27693(" + Y"), class_2561.method_43471((String)"fzmm.gui.hotkey.ctrl").method_27693(" + ").method_10852((class_2561)class_2561.method_43471((String)"fzmm.gui.hotkey.shift")).method_27693(" + Z")));
    }

    public boolean keyPressed(int keyCode, int modifiers) {
        if (keyCode == 90 && (modifiers & 2) != 0 && (modifiers & 1) == 0) {
            return this.undo();
        }
        if (keyCode == 90 && (modifiers & 2) != 0 && (modifiers & 1) != 0 || keyCode == 89 && (modifiers & 2) != 0) {
            return this.redo();
        }
        return false;
    }

    public void onChange(Consumer<IClipboardState> consumer) {
        this.valueObservable.observe(consumer);
    }

    public void change(IClipboardState value) {
        this.valueObservable.set((Object)value.copy());
    }

    public void addUndo(IClipboardState newValue) {
        this.undoArray.push(newValue.copy());
        this.clearRedo();
        this.updateButtons();
        if (this.undoArray.size() > this.maxSize) {
            this.undoArray.removeLast();
        }
    }

    public boolean undo() {
        if (this.undoArray.isEmpty()) {
            return false;
        }
        this.redoArray.push((IClipboardState)this.valueObservable.get());
        this.valueObservable.set((Object)this.undoArray.pop().copy());
        this.updateButtons();
        return true;
    }

    public boolean redo() {
        if (this.redoArray.isEmpty()) {
            return false;
        }
        this.undoArray.push((IClipboardState)this.valueObservable.get());
        this.valueObservable.set((Object)this.redoArray.pop().copy());
        this.updateButtons();
        return true;
    }

    public void clearUndo() {
        this.undoArray.clear();
        this.undoButton.active(false);
        this.clearRedo();
    }

    public void clearRedo() {
        this.redoArray.clear();
        this.redoButton.active(false);
    }

    public boolean hasUndo() {
        return !this.undoArray.isEmpty();
    }

    public boolean hasRedo() {
        return !this.redoArray.isEmpty();
    }

    private void updateButtons() {
        this.undoButton.active(this.hasUndo());
        this.redoButton.active(this.hasRedo());
    }
}

