/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.command.argument_type;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class ComponentArgumentType
implements ArgumentType<class_2487> {
    private static final int MAX_DEPTH = 510;
    private static final Collection<String> EXAMPLES = Arrays.asList("{}", "{foo:'bar'}", "[foo='bar']");

    public static ComponentArgumentType component() {
        return new ComponentArgumentType();
    }

    public static <S> class_2487 getNbtCompound(CommandContext<S> context, String name) {
        return (class_2487)context.getArgument(name, class_2487.class);
    }

    public class_2487 parse(StringReader stringReader) throws CommandSyntaxException {
        if (!ComponentArgumentType.maxDepthCheck(stringReader)) {
            throw class_2203.field_41706.createWithContext((ImmutableStringReader)stringReader);
        }
        class_2522 nbtReader = new class_2522(stringReader);
        if (stringReader.peek() == '[') {
            return this.parseComponent(stringReader, nbtReader);
        }
        return nbtReader.method_10727();
    }

    private class_2487 parseComponent(StringReader stringReader, class_2522 nbtReader) throws CommandSyntaxException {
        class_2487 compound = new class_2487();
        StringBuilder keyBuilder = new StringBuilder();
        stringReader.expect('[');
        stringReader.skipWhitespace();
        while (stringReader.canRead()) {
            char c = stringReader.peek();
            int oldCursor = stringReader.getCursor();
            stringReader.skip();
            stringReader.skipWhitespace();
            if (c == '=') {
                String key = keyBuilder.toString();
                keyBuilder = new StringBuilder();
                compound.method_10566(key, nbtReader.method_10723());
                continue;
            }
            if (c == ']') {
                stringReader.setCursor(oldCursor);
                stringReader.skip();
                break;
            }
            if (c == ',') continue;
            keyBuilder.append(c);
        }
        return compound;
    }

    public static boolean maxDepthCheck(StringReader stringReader) {
        int originalCursor = stringReader.getCursor();
        int curlyDepth = 0;
        int squareDepth = 0;
        boolean inString = false;
        int inStringEscapeDepth = 0;
        char stringDelimiter = '\u0000';
        boolean result = true;
        while (stringReader.getRemainingLength() > 0) {
            char current = stringReader.peek();
            int cursor = stringReader.getCursor();
            stringReader.skip();
            if (inString) {
                if (current != stringDelimiter || inStringEscapeDepth != ComponentArgumentType.countRepeatedPrevious(stringReader, cursor, '\\')) continue;
                inString = false;
                continue;
            }
            if (current == '\"' || current == '\'') {
                inString = true;
                stringDelimiter = current;
                inStringEscapeDepth = ComponentArgumentType.countRepeatedPrevious(stringReader, cursor, '\\');
                continue;
            }
            if (current == '{') {
                ++curlyDepth;
            } else if (current == '}') {
                if (--curlyDepth < 0) {
                    break;
                }
            } else if (current == '[') {
                ++squareDepth;
            } else if (current == ']' && --squareDepth < 0) break;
            if (curlyDepth + squareDepth <= 510) continue;
            result = false;
            break;
        }
        stringReader.setCursor(originalCursor);
        return result;
    }

    public static int countRepeatedPrevious(StringReader stringReader, int cursor, char c) {
        int result = 0;
        int originalCursor = stringReader.getCursor();
        stringReader.setCursor(cursor);
        while (stringReader.peek(-result) == c) {
            ++result;
        }
        stringReader.setCursor(originalCursor);
        return result;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

