/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.BookComponent;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.SnackBarLayout;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.component.EBooleanButton;
import fzmm.zailer.me.client.gui.components.extend.component.ETextureComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.extend.container.EScrollContainer;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ScreenshotZoneComponent;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.row.ConfigTextBoxRow;
import fzmm.zailer.me.client.gui.components.row.ContextMenuButtonRow;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.client.gui.components.tabs.TabContainer;
import fzmm.zailer.me.client.gui.text_format.components.ColorListContainer;
import fzmm.zailer.me.client.logic.history.FzmmHistory;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.compat.symbol_chat.SymbolChatCompat;
import fzmm.zailer.me.compat.symbol_chat.components.FontTextBoxComponent;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public abstract class BaseFzmmScreen
extends BaseUIModelScreen<EFlowLayout>
implements ISnackBarScreen {
    @Nullable
    protected class_437 parent;
    protected final String baseScreenTranslationKey;
    public static final int BUTTON_TEXT_PADDING = 8;
    public static final int COMPONENT_DISTANCE = 8;
    private final SymbolChatCompat symbolChatCompat;
    protected final FlowLayout snackBarLayout;

    public BaseFzmmScreen(String screenPath, String baseScreenTranslationKey, @Nullable class_437 parent) {
        super(EFlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_60655((String)"fzmm", (String)screenPath)));
        this.baseScreenTranslationKey = baseScreenTranslationKey;
        this.parent = parent;
        this.symbolChatCompat = new SymbolChatCompat();
        this.snackBarLayout = new SnackBarLayout(Sizing.content(), Sizing.content());
    }

    protected void build(EFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        ButtonComponent backButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, "back-button");
        if (backButton != null) {
            backButton.onPress(button -> this.method_25419());
        }
        this.setup(rootComponent);
        rootComponent.child((Component)this.snackBarLayout);
    }

    protected void method_25426() {
        BaseFzmmScreen baseFzmmScreen;
        super.method_25426();
        Optional<EFlowLayout> root = this.getRoot();
        if (root.isEmpty()) {
            return;
        }
        if (FzmmClient.CONFIG.history.automaticallyRecoverScreens() && (baseFzmmScreen = this) instanceof IMemento) {
            IMemento memento = (IMemento)((Object)baseFzmmScreen);
            FzmmHistory.restoreScreen(memento);
        }
        if (root.get().focusHandler() != null) {
            this.initFocus(root.get().focusHandler());
        }
    }

    protected void initFocus(FocusHandler focusHandler) {
    }

    protected abstract void setup(EFlowLayout var1);

    public void method_25432() {
        BaseFzmmScreen baseFzmmScreen;
        this.clearSnackBars();
        if (FzmmClient.CONFIG.history.automaticallyRecoverScreens() && (baseFzmmScreen = this) instanceof IMemento) {
            IMemento memento = (IMemento)((Object)baseFzmmScreen);
            if (!this.invalid) {
                FzmmHistory.saveScreen(memento);
            }
        }
        super.method_25432();
    }

    public void method_25419() {
        this.setScreen(this.parent);
    }

    public String getBaseScreenTranslationKey() {
        return this.baseScreenTranslationKey;
    }

    public static String getBaseTranslationKey(Element element) {
        String string;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseFzmmScreen = (BaseFzmmScreen)currentScreen;
            string = baseFzmmScreen.getBaseScreenTranslationKey();
        } else {
            string = element.getAttribute("baseScreenTranslationKey");
        }
        return string;
    }

    public static String getBaseTranslationKey(String baseTranslationKey) {
        return "fzmm.gui." + baseTranslationKey;
    }

    public static String getOptionBaseTranslationKey(String baseScreenTranslationKey) {
        return BaseFzmmScreen.getBaseTranslationKey(baseScreenTranslationKey) + ".option.";
    }

    public void child(Component child) {
        ((EFlowLayout)this.uiAdapter.rootComponent).child(child);
    }

    @Override
    public FlowLayout getSnackBarLayout() {
        return this.snackBarLayout;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.symbolChatCompat.symbol().isMounted()) {
                this.symbolChatCompat.symbol().remove();
                this.symbolChatCompat.selectedComponent(null);
                return true;
            }
            if (this.symbolChatCompat.font().isMounted()) {
                this.symbolChatCompat.font().remove();
                this.symbolChatCompat.selectedComponent(null);
                return true;
            }
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.symbolChatCompat.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        return this.symbolChatCompat.charTyped(chr, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public SymbolChatCompat getSymbolChatCompat() {
        return this.symbolChatCompat;
    }

    public UIModel getModel() {
        return this.model;
    }

    public Optional<EFlowLayout> getRoot() {
        if (this.uiAdapter == null) {
            return Optional.empty();
        }
        return Optional.of((EFlowLayout)this.uiAdapter.rootComponent);
    }

    static {
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"button-row"), ButtonRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"color-row"), ColorRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"predicate-text-box-row"), ConfigTextBoxRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"context-menu-button-row"), ContextMenuButtonRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"image-rows"), ImageRows::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"number-row"), NumberRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"slider-row"), SliderRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"text-box-row"), TextBoxRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"boolean-button"), EBooleanButton::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"button"), element -> EComponents.button((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"item"), element -> EComponents.item(class_1799.field_8037));
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"label"), element -> EComponents.label((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"texture"), ETextureComponent::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"flow-layout"), EFlowLayout::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"scroll"), EScrollContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"tab-container"), TabContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"book"), element -> new BookComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"context-menu-button"), element -> new ContextMenuButton((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"number-slider"), element -> new SliderWidget());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"text-option"), element -> new ConfigTextBox());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"suggest-text-option"), element -> new SuggestionTextBox());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"image-option"), element -> new ImageButtonComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"screenshot-zone"), element -> new ScreenshotZoneComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"color-list"), ColorListContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_60655((String)"fzmm", (String)"font-text-box"), element -> new FontTextBoxComponent(Sizing.fixed((int)100)));
    }
}

