/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.extend.container;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class EFlowLayout
extends FlowLayout {
    @Nullable
    private Surface hoveredSurface = null;
    private boolean isFocused = false;

    public EFlowLayout(Sizing horizontalSizing, Sizing verticalSizing, FlowLayout.Algorithm algorithm) {
        super(horizontalSizing, verticalSizing, algorithm);
    }

    public Surface styledPanel() {
        return Surface.DARK_PANEL;
    }

    public Surface styledBackground() {
        boolean useOldVanillaBackground = FzmmClient.CONFIG.guiStyle.oldBackground();
        return useOldVanillaBackground ? Surface.VANILLA_TRANSLUCENT : Surface.OPTIONS_BACKGROUND;
    }

    private Optional<Surface> parseStyledSurface(Element surfaceElement) {
        List children = UIParsing.allChildrenOfType((Element)surfaceElement, (short)1);
        Surface result = Surface.BLANK;
        boolean modified = false;
        for (Element child : children) {
            result = switch (child.getNodeName()) {
                case "options-background", "vanilla-translucent" -> {
                    modified = true;
                    yield result.and(this.styledBackground());
                }
                default -> result;
            };
        }
        return modified ? Optional.of(result) : Optional.empty();
    }

    public EFlowLayout hoveredSurface(@Nullable Surface hoveredSurface) {
        this.hoveredSurface = hoveredSurface;
        return this;
    }

    public <T extends Component> T childByIdOrThrow(@NotNull Class<T> expectedClass, @NotNull String id) {
        Component result = this.childById(expectedClass, id);
        if (result == null) {
            throw new NullPointerException(String.format("No '%s' found with component id '%s'", expectedClass.getSimpleName(), id));
        }
        return (T)result;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"surface", this::parseStyledSurface, surfaceOptional -> surfaceOptional.ifPresent(arg_0 -> ((EFlowLayout)this).surface(arg_0)));
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        this.surface.draw(context, (ParentComponent)this);
        if (this.hoveredSurface != null && (this.isInBoundingBox(mouseX, mouseY) || this.isFocused)) {
            this.hoveredSurface.draw(context, (ParentComponent)this);
        }
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.children);
    }

    public void onFocusGained(Component.FocusSource source) {
        super.onFocusGained(source);
        this.isFocused = true;
    }

    public void onFocusLost() {
        super.onFocusLost();
        this.isFocused = false;
    }

    public static FlowLayout parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"direction"});
        return switch (element.getAttribute("direction")) {
            case "horizontal" -> EContainers.horizontalFlow(Sizing.content(), Sizing.content());
            case "ltr-text-flow" -> EContainers.ltrTextFlow(Sizing.content(), Sizing.content());
            default -> EContainers.verticalFlow(Sizing.content(), Sizing.content());
        };
    }
}

