/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class SliderRow
extends AbstractRow {
    public SliderRow(String baseTranslationKey, String id, String tooltipId, boolean translation) {
        super(baseTranslationKey, id, tooltipId, true, translation);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component slider = new SliderWidget().horizontalSizing(Sizing.fixed((int)200)).id(SliderRow.getSliderId(id));
        return new Component[]{slider};
    }

    public static String getSliderId(String id) {
        return id + "-slider";
    }

    public static SliderWidget setup(EFlowLayout rootComponent, String id, double defaultValue, double min, double max, Class<? extends Number> numberType, int decimalPlaces, double scrollStep, @Nullable Consumer<Double> callback) {
        SliderWidget numberSlider = rootComponent.childByIdOrThrow(SliderWidget.class, SliderRow.getSliderId(id));
        ButtonComponent resetButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, SliderRow.getResetButtonId(id));
        numberSlider.decimalPlaces(decimalPlaces);
        numberSlider.valueType(numberType);
        numberSlider.onChanged().subscribe(aDouble -> {
            double discreteValue = numberSlider.discreteValue();
            if (resetButton != null) {
                boolean bl = resetButton.field_22763 = discreteValue != defaultValue;
            }
            if (callback != null) {
                callback.accept(discreteValue);
            }
        });
        numberSlider.min(min);
        numberSlider.max(max);
        numberSlider.setFromDiscreteValue(defaultValue);
        numberSlider.method_25346();
        numberSlider.scrollStep(scrollStep / (max - min));
        if (resetButton != null) {
            resetButton.onPress(button -> numberSlider.setFromDiscreteValue(defaultValue));
            resetButton.field_22763 = false;
        }
        return numberSlider;
    }

    public SliderWidget getWidget() {
        return (SliderWidget)this.childById(SliderWidget.class, SliderRow.getSliderId(this.getId()));
    }

    public static SliderRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = SliderRow.getId(element);
        String tooltipId = SliderRow.getTooltipId(element, id);
        return new SliderRow(baseTranslationKey, id, tooltipId, true);
    }
}

