/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.snack_bar;

import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.client.gui.components.snack_bar.SnackBarBuilder;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BaseSnackBarComponent
extends EFlowLayout
implements ISnackBarComponent {
    protected boolean timerEnabled = false;
    protected long timerMillis = -1L;
    protected long startTimeMillis = 0L;
    @Nullable
    protected FlowLayout timerComponent = null;
    protected boolean removeOnLimit = true;
    protected List<ButtonComponent> buttons = List.of();

    protected BaseSnackBarComponent(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        this.zIndex(900);
    }

    @Override
    public ISnackBarComponent startTimer() {
        if (!this.timerEnabled) {
            EFlowLayout timerLayout = EContainers.horizontalFlow(Sizing.expand((int)100), Sizing.fixed((int)2));
            timerLayout.positioning(Positioning.relative((int)0, (int)100));
            this.timerComponent = EContainers.horizontalFlow(Sizing.fixed((int)0), Sizing.expand((int)100));
            this.timerComponent.surface(Surface.flat((int)Color.WHITE.argb()));
            timerLayout.child((Component)this.timerComponent);
            this.child((Component)timerLayout);
        }
        this.timerEnabled = true;
        this.startTimeMillis = System.currentTimeMillis();
        return this;
    }

    @Override
    public boolean removeOnLimit() {
        return this.removeOnLimit;
    }

    @Override
    public void removeOnLimit(boolean value) {
        this.removeOnLimit = value;
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842 && !(client.field_1755 instanceof ISnackBarScreen)) {
            return;
        }
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        if (this.timerComponent != null) {
            this.updateTimer(System.currentTimeMillis() - this.startTimeMillis);
        }
    }

    @Override
    public void setTimer(long timerMillis) {
        double configDisplayTime = (Double)class_310.method_1551().field_1690.method_48191().method_41753();
        this.timerMillis = (long)((double)timerMillis * configDisplayTime);
    }

    @Override
    public void updateTimer(long time) {
        if (!this.timerEnabled || this.timerMillis <= 0L) {
            return;
        }
        float percent = (float)time / (float)this.timerMillis;
        this.updateTimerBar(percent);
        if (time > this.timerMillis) {
            this.timerEnabled = false;
            this.close();
        }
    }

    @Override
    public void updateTimerBar(float percent) {
        int totalWidth = this.width();
        int width = (int)((float)totalWidth * percent);
        if (this.timerComponent != null) {
            this.timerComponent.horizontalSizing(Sizing.fixed((int)width));
        }
    }

    @Override
    public void add(Component toast) {
        this.child(toast);
    }

    @Override
    public void setButtons(List<ButtonComponent> buttons) {
        this.buttons = buttons;
    }

    @Override
    public void buttonsEnabled(boolean value) {
        class_124 color = value ? class_124.field_1068 : class_124.field_1063;
        for (ButtonComponent button : this.buttons) {
            class_5250 text = button.method_25369().method_27661();
            button.method_25355((class_2561)text.method_10862(text.method_10866().method_27706(color)));
            button.field_22763 = value;
        }
    }

    public static SnackBarBuilder builder(String id) {
        return SnackBarBuilder.builder(new BaseSnackBarComponent(Sizing.content(), Sizing.content()), id);
    }
}

