/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.converters.tabs;

import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.tabs.ITab;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.ButtonComponent;
import java.util.UUID;
import net.minecraft.class_5819;

public class ConverterArrayToUuidTab
implements ITab {
    private static final int ARRAY_SIZE = 4;
    private ConfigTextBox[] textBoxArray;

    @Override
    public String getId() {
        return "arrayToUuid";
    }

    @Override
    public String getTranslationKey() {
        return "fzmm.gui.converters.tab." + this.getId();
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.textBoxArray = new ConfigTextBox[4];
        for (int i = 0; i != 4; ++i) {
            this.textBoxArray[i] = NumberRow.setup(rootComponent, this.getArrayId(i), 0.0, Integer.class);
        }
        rootComponent.childByIdOrThrow(ButtonComponent.class, "arrayToUuid.random-button").onPress(button -> {
            class_5819 random = class_5819.method_43047();
            for (ConfigTextBox element : this.textBoxArray) {
                element.text(String.valueOf(random.method_43054()));
            }
        });
        rootComponent.childByIdOrThrow(ButtonComponent.class, "arrayToUuid.copy-button").onPress(button -> {
            int[] intArray = new int[4];
            for (int i = 0; i != 4; ++i) {
                intArray[i] = (Integer)this.textBoxArray[i].parsedValue();
            }
            long msb = Integer.toUnsignedLong(intArray[0]);
            long lsb = Integer.toUnsignedLong(intArray[2]);
            msb = msb << 32 | Integer.toUnsignedLong(intArray[1]);
            lsb = lsb << 32 | Integer.toUnsignedLong(intArray[3]);
            SnackBarManager.copyToClipboard(new UUID(msb, lsb).toString());
        });
    }

    public String getArrayId(int index) {
        return String.format("array%s", "." + index);
    }
}

