/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.algorithms;

import fzmm.zailer.me.client.gui.components.tabs.ITab;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.utils.ImageUtils;
import java.awt.image.BufferedImage;

public interface IImagetextAlgorithm
extends IMemento,
ITab {
    @Override
    public String getId();

    @Override
    default public String getTranslationKey() {
        return "fzmm.gui.imagetext.tab.algorithm." + this.getId();
    }

    public BufferedImage image();

    public void image(BufferedImage var1);

    public void build();

    public String[] linePixels(int var1);

    public String pixelExample();

    default public int colorAt(int x, int y) {
        return this.image().getRGB(x, y);
    }

    public float widthRatio();

    public float heightRatio();

    public void setUpdatePreviewCallback(Runnable var1);

    default public boolean tryUpdateCache(ImagetextData data) {
        BufferedImage image = this.image();
        if (image == null || image.getWidth() != data.width() || image.getHeight() != data.height()) {
            this.clearCache();
            this.image(ImageUtils.fastResizeImage(data.image(), data.width(), data.height(), data.smoothRescaling()));
            return true;
        }
        return false;
    }

    default public void clearCache() {
        BufferedImage image = this.image();
        if (image != null) {
            image.flush();
            this.image(null);
        }
    }
}

