/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.BookBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.options.BookOption;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Sizing;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class ImagetextBookTooltipTab
implements IImagetextTab,
IMemento {
    private ContextMenuButton bookTooltipButton;
    private BookOption bookMode;
    private TextBoxComponent bookTooltipAuthor;
    private TextAreaComponent bookTooltipMessage;

    @Override
    public void build(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.buildImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        String author = this.bookTooltipAuthor.method_1882();
        String bookMessage = this.bookTooltipMessage.method_44405();
        BookBuilder bookBuilder = this.bookMode.getBookBuilder().author(author).addPage((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1078) + bookMessage)).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)logic.mergeText()))));
        class_1799 book = bookBuilder.get();
        int serializedLength = bookBuilder.exceedsSerializedLengthLimit();
        if (serializedLength != -1) {
            class_310.method_1551().execute(() -> {
                ISnackBarComponent toast = BaseSnackBarComponent.builder("imagetext").title((class_2561)class_2561.method_43469((String)"fzmm.snack_bar.bookTooltip.overflow.title", (Object[])new Object[]{serializedLength, Short.MAX_VALUE})).details((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.bookTooltip.overflow.details")).backgroundColor(EStyles.ALERT_ERROR_COLOR).keepOnLimit().highTimer().startTimer().closeButton().build();
                SnackBarManager.getInstance().add(toast);
            });
            return;
        }
        ItemUtils.give(book);
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        assert (class_310.method_1551().field_1724 != null);
        this.bookTooltipButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "bookTooltipMode");
        this.bookTooltipButton.setContextMenuOptions(dropdownComponent -> {
            for (BookOption option : BookOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateBookTooltip(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBookTooltip(BookOption.ADD_PAGE);
        this.bookTooltipAuthor = TextBoxRow.setup(rootComponent, "bookTooltipAuthor", class_310.method_1551().field_1724.method_5477().getString(), 512);
        this.bookTooltipMessage = rootComponent.childByIdOrThrow(TextAreaComponent.class, "bookTooltipMessage-text-area");
        this.bookTooltipMessage.maxLines(14);
        this.bookTooltipMessage.method_44402(4096);
        this.bookTooltipMessage.text(FzmmClient.CONFIG.imagetext.defaultBookMessage());
        FlowLayout layout = rootComponent.childByIdOrThrow(FlowLayout.class, "bookTooltipMessage-text-area-parent");
        layout.verticalSizing(Sizing.content());
    }

    private void updateBookTooltip(BookOption mode) {
        this.bookMode = mode;
        this.bookTooltipButton.method_25355((class_2561)class_2561.method_43471((String)this.bookMode.getTranslationKey()));
    }

    @Override
    public String getId() {
        return "bookTooltip";
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.bookTooltipAuthor.method_1882());
        output.writeObject(this.bookTooltipMessage.method_44405());
        output.writeObject(this.bookMode);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.bookTooltipAuthor.text((String)input.readObject());
        this.bookTooltipMessage.text((String)input.readObject());
        this.updateBookTooltip((BookOption)input.readObject());
    }
}

