/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTooltip;
import fzmm.zailer.me.client.gui.options.LoreOption;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ImagetextLoreTab
implements IImagetextTab,
IImagetextTooltip,
IMemento {
    private ContextMenuButton loreModeButton;
    private LoreOption loreMode;

    @Override
    public void build(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.buildImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        class_1799 stack = this.getStack(this.loreMode);
        List<class_2561> imagetext = logic.text();
        DisplayBuilder display = DisplayBuilder.of(stack);
        display.addLore(imagetext).get();
        ItemUtils.give(display.get());
    }

    @Override
    public String getId() {
        return "lore";
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.loreModeButton = rootComponent.childByIdOrThrow(ContextMenuButton.class, "loreMode");
        this.loreModeButton.setContextMenuOptions(dropdownComponent -> {
            for (LoreOption option : LoreOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateLoreMode(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateLoreMode(LoreOption.ADD);
    }

    private void updateLoreMode(LoreOption mode) {
        this.loreMode = mode;
        this.loreModeButton.method_25355((class_2561)class_2561.method_43471((String)this.loreMode.getTranslationKey()));
    }

    @Override
    public class_2561 getTooltip(ImagetextLogic logic) {
        class_1799 stack = this.getStack(this.loreMode);
        int loreSize = ((class_9290)stack.method_57353().method_57830(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2400().size() + logic.height();
        class_5250 currentLore = class_2561.method_43470((String)String.valueOf(loreSize));
        if (loreSize > 256) {
            currentLore.method_10862(currentLore.method_10866().method_36139(EStyles.TEXT_ERROR_COLOR.rgb()));
        }
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.lore.tooltip", (Object[])new Object[]{currentLore, 256});
    }

    private class_1799 getStack(LoreOption option) {
        assert (class_310.method_1551().field_1724 != null);
        class_1799 stack = ItemUtils.from(class_1268.field_5808);
        if (stack.method_7960()) {
            stack = ItemUtils.from(FzmmClient.CONFIG.imagetext.defaultItem()).method_7854();
        }
        return switch (option) {
            default -> throw new MatchException(null, null);
            case LoreOption.ADD -> stack;
            case LoreOption.REPLACE -> {
                stack.method_57368(class_9334.field_49632, null, component -> new class_9290(List.of()));
                yield stack;
            }
        };
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.loreMode);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.loreMode = (LoreOption)input.readObject();
        this.updateLoreMode(this.loreMode);
    }
}

