/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.player_statue.tabs;

import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.image.ImageStatus;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.options.HorizontalDirectionOption;
import fzmm.zailer.me.client.gui.player_statue.tabs.IPlayerStatueTab;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.logic.head_generator.model.InternalModels;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.player_statue.PlayerStatue;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.ItemUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import org.joml.Vector3f;

public class PlayerStatueGenerateTab
implements IPlayerStatueTab,
IMemento {
    private static final ImageStatus INVALID_SKIN_SIZE = new ImageStatus("error.title", "error.details.playerStatue.invalidSkinSize", true);
    private static CompletableFuture<Void> CREATE_COMPLETABLE_FUTURE = null;
    private ImageRowsElements skinElements;
    private class_4185 executeButton;

    @Override
    public String getId() {
        return "generate";
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.skinElements = ImageRows.setup(rootComponent, "skin", "skin-source", ImageMode.NAME);
        this.executeButton = (class_4185)rootComponent.childById(class_4185.class, "execute-button");
        ImageButtonComponent skinButton = this.skinElements.imageButton();
        skinButton.setImageLoadedEvent(this::skinCallback);
        skinButton.setButtonCallback(skinOptional -> {
            this.executeButton.field_22763 = this.canExecute();
            if (skinOptional.isEmpty()) {
                return;
            }
            BufferedImage skin = (BufferedImage)skinOptional.get();
            if (skin.getWidth() == 64 && skin.getHeight() == 32) {
                skinButton.setImage(InternalModels.OLD_FORMAT_TO_NEW_FORMAT.getHeadSkin(skin, ImageUtils.hasUnusedPixel(skin)));
            }
        });
    }

    @Override
    public void execute(HorizontalDirectionOption direction, float x, float y, float z, String name) {
        if (!this.canExecute()) {
            return;
        }
        Optional<BufferedImage> image = this.skinElements.imageButton().getImage();
        if (image.isEmpty()) {
            return;
        }
        CREATE_COMPLETABLE_FUTURE = CompletableFuture.runAsync(() -> {
            this.executeButton.field_22763 = false;
            Vector3f pos = new Vector3f(x, y, z);
            class_1799 statueGenerated = new PlayerStatue((BufferedImage)image.get(), name, pos, direction).generateStatues().getStatueInContainer();
            ItemUtils.give(statueGenerated);
            InvisibleEntityWarning.add(true, true, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.playerStatue"), "PlayerStatue");
            this.executeButton.field_22763 = true;
            CREATE_COMPLETABLE_FUTURE = null;
        });
    }

    @Override
    public boolean canExecute() {
        return this.canExecute(this.skinElements.imageButton().hasImage());
    }

    public boolean canExecute(boolean hasImage) {
        return hasImage && CREATE_COMPLETABLE_FUTURE == null;
    }

    public ImageStatus skinCallback(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (!(width == 64 && height == 32 || width == 64 && height == 64 || width == 128 && height == 128)) {
            return INVALID_SKIN_SIZE;
        }
        return ImageStatus.IMAGE_LOADED;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.skinElements.valueField().method_1882());
        output.writeObject((Object)this.skinElements.mode().get());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.skinElements.valueField().text((String)input.readObject());
        this.skinElements.imageModeButtons().get((Object)((ImageMode)((Object)input.readObject()))).method_25306();
    }
}

