/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.extend.component.EBooleanButton;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.tabs.ITab;
import fzmm.zailer.me.client.gui.components.tabs.TabContainer;
import fzmm.zailer.me.client.gui.text_format.tabs.ITextFormatTab;
import fzmm.zailer.me.client.gui.text_format.tabs.TextFormatGradientTab;
import fzmm.zailer.me.client.gui.text_format.tabs.TextFormatInterleavedColorsTab;
import fzmm.zailer.me.client.gui.text_format.tabs.TextFormatPlaceholderApiTab;
import fzmm.zailer.me.client.gui.text_format.tabs.TextFormatRainbowTab;
import fzmm.zailer.me.client.gui.text_format.tabs.TextFormatSimpleTab;
import fzmm.zailer.me.client.gui.utils.CopyTextScreen;
import fzmm.zailer.me.client.logic.TextFormatLogic;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.util.FocusHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class TextFormatScreen
extends BaseFzmmScreen
implements IMemento {
    public static final class_2561 EMPTY_COLOR_TEXT = class_2561.method_43471((String)"fzmm.gui.textFormat.error.emptyColor").method_10862(class_2583.field_24360.method_36139(EStyles.TEXT_ERROR_COLOR.rgb()));
    private LabelComponent messagePreviewLabel;
    private TextBoxComponent messageTextField;
    private EBooleanButton boldToggle;
    private EBooleanButton italicToggle;
    private EBooleanButton obfuscatedToggle;
    private EBooleanButton strikethroughToggle;
    private EBooleanButton underlineToggle;
    private FlowLayout stylesLayout;
    private List<class_4185> executeButtons;
    private TabContainer tabContainer;
    private boolean initialized = false;

    public TextFormatScreen(@Nullable class_437 parent) {
        super("text_format", "textFormat", parent);
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        this.messagePreviewLabel = rootComponent.childByIdOrThrow(LabelComponent.class, "message-preview");
        this.messageTextField = TextBoxRow.setup(rootComponent, "message", "Hello world", 4096, s -> this.updateMessagePreview());
        this.stylesLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "styles-layout");
        this.boldToggle = this.setupStyleButton(rootComponent, "bold");
        this.italicToggle = this.setupStyleButton(rootComponent, "italic");
        this.obfuscatedToggle = this.setupStyleButton(rootComponent, "obfuscated");
        this.strikethroughToggle = this.setupStyleButton(rootComponent, "strikethrough");
        this.underlineToggle = this.setupStyleButton(rootComponent, "underline");
        this.tabContainer = rootComponent.childByIdOrThrow(TabContainer.class, "tabs");
        List<TextFormatPlaceholderApiTab> tabs = List.of(new TextFormatSimpleTab(), new TextFormatGradientTab(), new TextFormatInterleavedColorsTab(), new TextFormatRainbowTab(), new TextFormatPlaceholderApiTab());
        this.tabContainer.addParsedTabs(tabs).onSelect(this::onSelectTab).setupTabs(rootComponent, ((ITextFormatTab)tabs.get(0)).getId());
        for (ITextFormatTab iTextFormatTab : tabs) {
            iTextFormatTab.componentsCallback(object -> this.updateMessagePreview());
        }
        this.tabContainer.selectTab();
        this.setupBottomButtons(rootComponent);
        this.initialized = true;
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.messageTextField, Component.FocusSource.MOUSE_CLICK);
    }

    private void onSelectTab(ITab tab) {
        for (Component child : this.stylesLayout.children()) {
            if (!(child instanceof ButtonComponent)) continue;
            ButtonComponent buttonComponent = (ButtonComponent)child;
            buttonComponent.active(((ITextFormatTab)tab).hasStyles());
        }
        this.updateMessagePreview();
    }

    private void setupBottomButtons(EFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        FzmmConfig.TextFormat config = FzmmClient.CONFIG.textFormat;
        boolean executeButtonsActive = this.messageTextField.method_1882().length() > 1;
        ButtonComponent addLoreButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "add-lore-button");
        addLoreButton.active(executeButtonsActive);
        addLoreButton.onPress(button -> {
            class_1799 handItem = ItemUtils.from(class_1268.field_5808);
            class_2561 text = this.messagePreviewLabel.text();
            DisplayBuilder builder = DisplayBuilder.of(handItem.method_7960() ? ItemUtils.from(config.defaultItem()).method_7854() : handItem).addLore(text);
            ItemUtils.give(builder.get());
        });
        ButtonComponent setNameButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "set-name-button");
        setNameButton.active(executeButtonsActive);
        setNameButton.onPress(button -> {
            class_1799 handItem = ItemUtils.from(class_1268.field_5808);
            class_2561 text = this.messagePreviewLabel.text();
            DisplayBuilder builder = DisplayBuilder.of(handItem.method_7960() ? ItemUtils.from(config.defaultItem()).method_7854() : handItem).setName(text.method_27661());
            ItemUtils.give(builder.get());
        });
        ButtonComponent randomButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "random-button");
        randomButton.active(executeButtonsActive);
        randomButton.onPress(button -> ((ITextFormatTab)this.tabContainer.selectedTab()).setRandomValues());
        ButtonComponent copyButton = rootComponent.childByIdOrThrow(ButtonComponent.class, "copy-button");
        copyButton.active(executeButtonsActive);
        copyButton.onPress(button -> this.setScreen((class_437)new CopyTextScreen((class_437)this, this.messagePreviewLabel.text())));
        this.executeButtons = List.of(addLoreButton, setNameButton, randomButton, copyButton);
    }

    public void updateMessagePreview() {
        if (!this.initialized) {
            return;
        }
        String message = this.messageTextField.method_1882();
        if (message.length() < 2) {
            this.toggleExecuteButtons(false);
            this.messagePreviewLabel.text((class_2561)class_2561.method_43471((String)"fzmm.gui.textFormat.error.messageLength").method_10862(class_2583.field_24360.method_36139(9515332)));
        }
        this.toggleExecuteButtons(true);
        boolean obfuscated = this.obfuscatedToggle.enabled();
        boolean bold = this.boldToggle.enabled();
        boolean strikethrough = this.strikethroughToggle.enabled();
        boolean underline = this.underlineToggle.enabled();
        boolean italic = this.italicToggle.enabled();
        TextFormatLogic logic = new TextFormatLogic(message, obfuscated, bold, strikethrough, underline, italic);
        class_2561 messagePreview = ((ITextFormatTab)this.tabContainer.selectedTab()).getText(logic);
        this.messagePreviewLabel.text(messagePreview);
    }

    private void toggleExecuteButtons(boolean value) {
        for (class_4185 button : this.executeButtons) {
            button.field_22763 = value;
        }
    }

    private EBooleanButton setupStyleButton(EFlowLayout rootComponent, String id) {
        EBooleanButton booleanButton = rootComponent.childByIdOrThrow(EBooleanButton.class, id);
        booleanButton.onPress(buttonComponent -> this.updateMessagePreview());
        booleanButton.enabled(false);
        return booleanButton;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.messageTextField.method_1882());
        output.writeBoolean(this.obfuscatedToggle.enabled());
        output.writeBoolean(this.boldToggle.enabled());
        output.writeBoolean(this.strikethroughToggle.enabled());
        output.writeBoolean(this.underlineToggle.enabled());
        output.writeBoolean(this.italicToggle.enabled());
        this.tabContainer.backup(output);
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.messageTextField.text((String)input.readObject());
        this.obfuscatedToggle.enabled(input.readBoolean());
        this.boldToggle.enabled(input.readBoolean());
        this.strikethroughToggle.enabled(input.readBoolean());
        this.underlineToggle.enabled(input.readBoolean());
        this.italicToggle.enabled(input.readBoolean());
        this.tabContainer.restore(input);
    }
}

