/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model.steps;

import com.google.gson.JsonObject;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.ModelData;
import fzmm.zailer.me.client.logic.head_generator.model.ModelPoint;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ColorParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.INestedParameters;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ModelParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ParameterList;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class ModelFunctionStep
implements IModelStep,
INestedParameters {
    private static final String FUNCTION_OFFSET_ID = "function_offset_";
    private final String functionPath;
    @Nullable
    private final ParameterList<BufferedImage> textures;
    @Nullable
    private final ParameterList<ColorParameter> colors;
    @Nullable
    private final ParameterList<OffsetParameter> offsets;
    @Nullable
    private final ParameterList<OffsetParameter> functionOffsets;
    private final boolean isInvertedLeftAndRight;

    public ModelFunctionStep(String functionPath, @Nullable ParameterList<BufferedImage> textures, @Nullable ParameterList<ColorParameter> colors, @Nullable ParameterList<OffsetParameter> offsets, ModelPoint pos, boolean isInvertedLeftAndRight) {
        this.functionPath = functionPath;
        this.textures = textures;
        this.colors = colors;
        this.offsets = offsets;
        this.functionOffsets = this.createFunctionOffsets(pos).orElse(null);
        this.isInvertedLeftAndRight = isInvertedLeftAndRight;
    }

    @Override
    public void apply(ModelData data) {
        ParameterList<ColorParameter> colors;
        Optional<HeadModelEntry> functionOptional = ModelFunctionStep.getFunction(this.functionPath);
        if (functionOptional.isEmpty()) {
            return;
        }
        HeadModelEntry function = functionOptional.get();
        BufferedImage destinationTexture = data.destinationTexture();
        BufferedImage baseSkin = data.getTexture("base_skin").orElseThrow(() -> {
            String message = "[ModelFunctionStep] Could not find base skin";
            FzmmClient.LOGGER.error(message);
            return new NullPointerException(message);
        });
        ParameterList<BufferedImage> textures = this.textures != null ? this.textures.copy() : null;
        ParameterList<OffsetParameter> offsets = this.offsets != null ? this.offsets.copy() : new ParameterList<OffsetParameter>();
        ParameterList<ColorParameter> parameterList = colors = this.colors != null ? this.colors.copy() : null;
        if (this.functionOffsets != null) {
            offsets.put(this.functionOffsets);
        }
        for (IParameterEntry<OffsetParameter> offset : data.offsets().parameterList()) {
            if (!offset.id().startsWith(FUNCTION_OFFSET_ID)) continue;
            offsets.put(offset);
        }
        ModelData functionData = new ModelData(data.destinationGraphics(), data.destinationId(), textures, colors, offsets, data.selectedTexture(), data.selectedColor(), this.isInvertedLeftAndRight, data.originalTransform());
        function.apply(functionData, baseSkin, destinationTexture);
        if (this.functionOffsets != null) {
            for (IParameterEntry<OffsetParameter> offset : this.functionOffsets.parameterList()) {
                offsets.remove(offset.id());
            }
        }
        data.offsets().put(functionData.offsets());
    }

    public static Optional<HeadModelEntry> getFunction(String functionPath) throws IllegalArgumentException {
        AbstractHeadEntry functionEntry = HeadResourcesLoader.getByPath(functionPath).orElseThrow(() -> {
            String message = String.format("[ModelFunctionStep] Could not find function step '%s'", functionPath);
            FzmmClient.LOGGER.error(message);
            return new IllegalArgumentException(message);
        });
        if (!(functionEntry instanceof HeadModelEntry)) {
            FzmmClient.LOGGER.warn("[ModelFunctionStep] '{}' is not a HeadModelEntry", (Object)functionPath);
            return Optional.empty();
        }
        HeadModelEntry function = (HeadModelEntry)functionEntry;
        return Optional.of(function);
    }

    private IParameterEntry<OffsetParameter> createOffset(int value, boolean isXAxis) {
        String key = FUNCTION_OFFSET_ID + UUID.randomUUID().toString().substring(0, 16);
        return new ModelParameter<OffsetParameter>(key, new OffsetParameter((byte)value, 0, 64, isXAxis, true), false);
    }

    private Optional<ParameterList<OffsetParameter>> createFunctionOffsets(ModelPoint pos) {
        ParameterList<OffsetParameter> functionOffsets = new ParameterList<OffsetParameter>();
        int x = pos.xWithOffset();
        int y = pos.yWithOffset();
        if (x != 0) {
            functionOffsets.put(this.createOffset(x, true));
        }
        if (y != 0) {
            functionOffsets.put(this.createOffset(y, false));
        }
        return functionOffsets.isEmpty() ? Optional.empty() : Optional.of(functionOffsets);
    }

    @Override
    public ParameterList<OffsetParameter> getOffsetParameters() {
        return this.offsets == null ? new ParameterList<OffsetParameter>() : this.offsets;
    }

    @Override
    public ParameterList<BufferedImage> getTextureParameters() {
        return this.textures == null ? new ParameterList<BufferedImage>() : this.textures;
    }

    @Override
    public ParameterList<ColorParameter> getColorParameters() {
        return this.colors == null ? new ParameterList<ColorParameter>() : this.colors;
    }

    @Override
    public List<IModelStep> getSteps() {
        Optional<HeadModelEntry> functionOptional = ModelFunctionStep.getFunction(this.functionPath);
        return functionOptional.isPresent() ? functionOptional.get().getSteps() : new ArrayList();
    }

    @Override
    public boolean validate() throws IllegalArgumentException {
        return ModelFunctionStep.getFunction(this.functionPath).isPresent();
    }

    public static ModelFunctionStep parse(JsonObject jsonObject) {
        String functionPath = HeadResourcesLoader.get(jsonObject, "function_path").getAsString();
        Optional<ParameterList<Object>> textures = HeadResourcesLoader.getParameterList(jsonObject, "textures", HeadResourcesLoader::textureParser);
        Optional<ParameterList<Object>> colors = HeadResourcesLoader.getParameterList(jsonObject, "colors", HeadResourcesLoader::colorParser);
        Optional<ParameterList<Object>> offsets = HeadResourcesLoader.getParameterList(jsonObject, "offsets", HeadResourcesLoader::offsetParser);
        ModelPoint point = jsonObject.has("pos") ? ModelPoint.parse(jsonObject.getAsJsonObject("pos")) : ModelPoint.ZERO;
        boolean isInvertedLeftAndRight = jsonObject.has("inverted_left_and_right") && jsonObject.get("inverted_left_and_right").getAsBoolean();
        return new ModelFunctionStep(functionPath, textures.orElse(null), colors.orElse(null), offsets.orElse(null), point, isInvertedLeftAndRight);
    }
}

