/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.history;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.client.logic.history.UniqueMementoCaretaker;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class FzmmHistory {
    private static final ArrayDeque<class_2487> GENERATED_ITEMS = new ArrayDeque();
    private static final ArrayDeque<class_2487> GENERATED_HEADS = new ArrayDeque();
    private static final UniqueMementoCaretaker SCREEN_CARETAKER = new UniqueMementoCaretaker();

    public static void onUpdateConfig() {
        FzmmConfig.History config = FzmmClient.CONFIG.history;
        FzmmHistory.removeExcess(GENERATED_ITEMS, config.maxItemHistory());
        FzmmHistory.removeExcess(GENERATED_HEADS, config.maxHeadHistory());
    }

    public static List<class_1799> getGeneratedItems() {
        return GENERATED_ITEMS.stream().map(FzmmHistory::parseNbt).toList();
    }

    public static List<class_1799> getGeneratedHeads() {
        return GENERATED_HEADS.stream().map(FzmmHistory::parseNbt).toList();
    }

    public static void add(class_1799 stack) {
        if (class_1802.field_8575 == stack.method_7909()) {
            FzmmHistory.addGeneratedHeads(stack);
        } else {
            FzmmHistory.addGeneratedItems(stack);
        }
    }

    public static void addGeneratedItems(class_1799 stack) {
        FzmmHistory.add(stack, GENERATED_ITEMS, FzmmClient.CONFIG.history.maxItemHistory());
    }

    public static void addGeneratedHeads(class_1799 stack) {
        FzmmHistory.add(stack, GENERATED_HEADS, FzmmClient.CONFIG.history.maxHeadHistory());
    }

    public static void add(class_1799 stack, ArrayDeque<class_2487> compounds, int max) {
        class_2487 stackCompound;
        try {
            stackCompound = (class_2487)stack.method_57375((class_7225.class_7874)FzmmUtils.getRegistryManager());
        }
        catch (Exception ignored) {
            return;
        }
        for (class_2487 compoundsFromHistory : compounds) {
            if (!compoundsFromHistory.equals((Object)stackCompound)) continue;
            compounds.remove(compoundsFromHistory);
            break;
        }
        compounds.addFirst(stackCompound);
        FzmmHistory.removeExcess(compounds, max);
    }

    public static void removeExcess(ArrayDeque<class_2487> compounds, int max) {
        if (max < 1) {
            compounds.clear();
            return;
        }
        while (max < compounds.size()) {
            compounds.removeLast();
        }
    }

    public static List<class_1799> getAllItems() {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        result.addAll(FzmmHistory.getGeneratedItems());
        result.addAll(FzmmHistory.getGeneratedHeads());
        return result;
    }

    public static void saveScreen(IMemento screen) {
        try {
            SCREEN_CARETAKER.backup(screen);
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[FzmmHistory] Failed to save memento", (Throwable)e);
        }
    }

    public static void restoreScreen(IMemento screen) {
        try {
            SCREEN_CARETAKER.restore(screen);
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[FzmmHistory] Failed to restore memento", (Throwable)e);
        }
    }

    private static class_1799 parseNbt(class_2487 nbt) {
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        return class_1799.method_57359((class_7225.class_7874)registryManager, (class_2487)nbt);
    }
}

