/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLineElement;
import fzmm.zailer.me.utils.FzmmUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8824;

public class ImagetextLine {
    public static final String DEFAULT_TEXT = "\u2588";
    private static final long LINE_WRAPPER_LENGTH;
    private static final long ELEMENT_LENGTH;
    private boolean isDefaultText;
    private final double similarityThreshold;
    private String[] characters;
    private ImagetextLineElement element;
    private class_5250 line;
    private int elementIndex;
    private long textLength;

    public ImagetextLine(double similarityThreshold) {
        this.characters(new String[]{DEFAULT_TEXT});
        this.similarityThreshold = similarityThreshold;
        this.reset();
    }

    public void reset() {
        this.element = null;
        this.line = class_2561.method_43473().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)));
        this.elementIndex = 0;
        this.textLength = 0L;
    }

    public void characters(String[] value) {
        this.characters = value;
        this.isDefaultText = value.length == 1 && value[0].equals(DEFAULT_TEXT);
    }

    public ImagetextLine add(int color) {
        if (this.element == null) {
            this.element = new ImagetextLineElement(color, this.isDefaultText);
        } else if (this.element.isSimilar(color, this.similarityThreshold)) {
            this.element.increment();
        } else {
            this.nextComponent(color);
        }
        return this;
    }

    private void nextComponent(int color) {
        if (this.element == null) {
            return;
        }
        class_2561 elementText = this.element.toText(this.characters, this.elementIndex);
        this.incrementTextLength(elementText.getString());
        this.line.method_10852(elementText);
        this.elementIndex += this.element.getRepetitions();
        this.element.reset(color, this.isDefaultText);
    }

    public class_2561 build() {
        this.nextComponent(-1);
        return this.line;
    }

    private void incrementTextLength(String characters) {
        this.textLength += (long)characters.length() + ELEMENT_LENGTH + 1L;
    }

    public long textLength() {
        return this.textLength + LINE_WRAPPER_LENGTH + 1L;
    }

    private static long textLength(class_2561 text) {
        return class_8824.field_46597.encodeStart(FzmmUtils.getRegistryOps(JsonOps.INSTANCE), (Object)text).result().map(JsonElement::toString).orElse(DEFAULT_TEXT).length() - 1;
    }

    static {
        class_5250 defaultText = class_2561.method_43470((String)DEFAULT_TEXT).method_10862(class_2583.field_24360.method_36139(1193046));
        ELEMENT_LENGTH = ImagetextLine.textLength((class_2561)defaultText) - 1L;
        LINE_WRAPPER_LENGTH = ImagetextLine.textLength((class_2561)class_2561.method_43473().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_10852((class_2561)defaultText)) - ELEMENT_LENGTH;
    }
}

