/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public final class ImagetextLineElement {
    private int elementColor;
    private short a;
    private short r;
    private short g;
    private short b;
    private int colorSum;
    private short repetitions;
    private boolean isEmptyText;

    public ImagetextLineElement(int pixelColor, boolean isDefaultText) {
        this.reset(pixelColor, isDefaultText);
    }

    public void reset(int color, boolean isDefaultText) {
        this.elementColor = color;
        this.a = (short)(color >> 24 & 0xFF);
        this.r = (short)(color >> 16 & 0xFF);
        this.g = (short)(color >> 8 & 0xFF);
        this.b = (short)(color & 0xFF);
        this.colorSum = this.a + this.r + this.g + this.b;
        this.repetitions = 1;
        this.isEmptyText = isDefaultText && this.a < 128;
    }

    public void increment() {
        this.repetitions = (short)(this.repetitions + 1);
    }

    public boolean isSimilar(int color, double percentageOfSimilarity) {
        if (this.elementColor == color) {
            return true;
        }
        Color colorObj = new Color(color, true);
        int a2 = colorObj.getAlpha();
        int r2 = colorObj.getRed();
        int g2 = colorObj.getGreen();
        int b2 = colorObj.getBlue();
        int colorsDifference = Math.abs(this.r - r2) + Math.abs(this.g - g2) + Math.abs(this.b - b2) + Math.abs(this.a - a2);
        return (double)colorsDifference * 100.0 / (double)this.colorSum < percentageOfSimilarity;
    }

    public short getRepetitions() {
        return this.repetitions;
    }

    public class_2561 toText(String[] charactersToUse, int lineIndex) {
        if (this.isEmptyText) {
            return this.toEmptyText();
        }
        StringBuilder textStrBuilder = new StringBuilder();
        int colorRGB = this.elementColor & 0xFFFFFF;
        for (int x = 0; x != this.repetitions; ++x) {
            textStrBuilder.append(this.getCharacter(charactersToUse, lineIndex++));
        }
        return class_2561.method_43470((String)textStrBuilder.toString()).method_10862(class_2583.field_24360.method_36139(colorRGB));
    }

    private class_2561 toEmptyText() {
        String spaceString = " ".repeat(this.repetitions);
        return class_2561.method_43470((String)(spaceString + String.valueOf(class_124.field_1067) + spaceString + String.valueOf(class_124.field_1070)));
    }

    private String getCharacter(String[] charactersToUse, int index) {
        return charactersToUse[index % charactersToUse.length];
    }
}

