/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.player_statue.statue_head_skin;

import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.HeadFace;
import fzmm.zailer.me.utils.SkinPart;
import fzmm.zailer.me.utils.position.PosI;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public abstract class AbstractStatueSkinManager {
    protected final SkinPart skinPart;

    protected AbstractStatueSkinManager(SkinPart skinPart) {
        this.skinPart = skinPart;
    }

    protected void draw(HeadFace.HEAD_FACE headFace, Graphics2D graphics, BufferedImage playerSkin, int scale) {
        PosI pos = this.skinPart.getNormalLayer();
        PosI hatPos = this.skinPart.getHatLayer();
        this.setPos(headFace, pos);
        headFace.get().draw(graphics, playerSkin, pos, false, scale);
        this.setPos(headFace, hatPos);
        headFace.get().draw(graphics, playerSkin, hatPos, true, scale);
    }

    private void setPos(HeadFace.HEAD_FACE headFace, PosI pos) {
        switch (headFace) {
            case LEFT_FACE: {
                this.setLeft(pos);
                break;
            }
            case RIGHT_FACE: {
                this.setRight(pos);
                break;
            }
            case FRONT_FACE: {
                this.setFront(pos);
                break;
            }
            case BACK_FACE: {
                this.setBack(pos);
                break;
            }
            case UP_FACE: {
                this.setUp(pos);
                break;
            }
            case BOTTOM_FACE: {
                this.setBottom(pos);
            }
        }
    }

    protected abstract void setLeft(PosI var1);

    protected abstract void setRight(PosI var1);

    protected abstract void setFront(PosI var1);

    protected abstract void setBack(PosI var1);

    protected abstract void setUp(PosI var1);

    protected abstract void setBottom(PosI var1);

    public static enum Height {
        LOWER(12),
        MIDDLE(8),
        UPPER(4);

        final int height;

        private Height(int height) {
            this.height = height;
        }

        int get() {
            return this.height;
        }
    }
}

