/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils.skin;

import com.mojang.authlib.GameProfile;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.skin.SkinGetterDecorator;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;

public class CacheSkinGetter
extends SkinGetterDecorator {
    public CacheSkinGetter(SkinGetterDecorator skinGetterDecorator) {
        super(skinGetterDecorator);
    }

    public CacheSkinGetter() {
    }

    @Override
    public Optional<BufferedImage> getSkin(String playerName) {
        Optional<GameProfile> profileOptional = this.getProfile(playerName);
        if (profileOptional.isEmpty()) {
            return super.getSkin(playerName);
        }
        Optional<BufferedImage> cacheSkin = this.getSkin(profileOptional.get());
        return cacheSkin.isPresent() ? cacheSkin : super.getSkin(playerName);
    }

    public Optional<BufferedImage> getSkin(GameProfile profile) {
        Optional textures;
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        try {
            textures = (Optional)client.method_1582().method_52863(profile).get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            return Optional.empty();
        }
        if (textures.isEmpty()) {
            return Optional.empty();
        }
        class_1044 texture = client.method_1531().method_4619(((class_8685)textures.get()).comp_1626());
        if (!(texture instanceof class_1043)) {
            return Optional.empty();
        }
        class_1043 nativeTexture = (class_1043)texture;
        class_1011 nativeImage = nativeTexture.method_4525();
        if (nativeImage == null) {
            return Optional.empty();
        }
        return Optional.of(ImageUtils.getBufferedImgFromNativeImg(nativeImage));
    }

    @Override
    public Optional<class_1799> getHead(String playerName) {
        Optional<GameProfile> profile = this.getProfile(playerName);
        return profile.map(HeadBuilder::of).or(() -> super.getHead(playerName));
    }

    @Override
    protected Optional<GameProfile> getProfile(String playerName) {
        class_640 playerListEntry = FzmmUtils.getOnlinePlayer(playerName);
        if (playerListEntry == null) {
            return Optional.empty();
        }
        return Optional.of(playerListEntry.method_2966());
    }
}

