/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.PropertyMap;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.skin.SkinGetterDecorator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_9296;

public class VanillaSkinGetter
extends SkinGetterDecorator {
    public VanillaSkinGetter(SkinGetterDecorator skinGetterDecorator) {
        super(skinGetterDecorator);
    }

    public VanillaSkinGetter() {
    }

    @Override
    public Optional<BufferedImage> getSkin(String playerName) {
        Optional<GameProfile> profile = this.getProfile(playerName);
        if (profile.isEmpty()) {
            return super.getSkin(playerName);
        }
        MinecraftProfileTexture skinTexture = class_310.method_1551().method_1495().getTextures(profile.get()).skin();
        if (skinTexture == null) {
            return super.getSkin(playerName);
        }
        try {
            Optional<BufferedImage> result = ImageUtils.getImageFromUrl(skinTexture.getUrl());
            if (result.isPresent()) {
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.getSkin(playerName);
    }

    @Override
    public Optional<class_1799> getHead(String playerName) {
        Optional<GameProfile> profile = this.getProfile(playerName);
        return profile.map(HeadBuilder::of).or(() -> super.getHead(playerName));
    }

    @Override
    public Optional<GameProfile> getProfile(String playerName) {
        try {
            return Optional.of(((class_9296)new class_9296(Optional.of(playerName), Optional.empty(), new PropertyMap()).method_57507().get()).comp_2413());
        }
        catch (InterruptedException | ExecutionException e) {
            FzmmClient.LOGGER.error("[VanillaSkinGetter] Failed to get profile for player '{}'", (Object)playerName, (Object)e);
            return Optional.empty();
        }
    }
}

