/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import fzmm.zailer.me.client.logic.history.FzmmHistory;
import fzmm.zailer.me.utils.ItemUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class HeadBuilder {
    private String skinValue = "";
    @Nullable
    private String headName = null;
    @Nullable
    private String signature;
    private UUID uuid = UUID.randomUUID();
    private boolean addToHeadHistory = true;

    private HeadBuilder() {
    }

    public static HeadBuilder builder() {
        return new HeadBuilder();
    }

    public class_1799 get() {
        class_1799 stack = class_1802.field_8575.method_7854();
        stack.method_57368(class_9334.field_49617, null, component -> {
            PropertyMap propertiesMap = new PropertyMap();
            propertiesMap.put((Object)"textures", (Object)new Property("textures", this.skinValue));
            return new class_9296(HeadBuilder.safeHeadName(this.headName), Optional.of(this.uuid), propertiesMap);
        });
        stack = ItemUtils.process(stack);
        if (this.addToHeadHistory) {
            FzmmHistory.addGeneratedHeads(stack);
        }
        return stack;
    }

    private static Optional<String> safeHeadName(@Nullable String headName) {
        if (headName == null) {
            return Optional.empty();
        }
        String headNameCopy = headName;
        if (headNameCopy.length() > 16) {
            headNameCopy = headNameCopy.substring(0, 16);
        }
        return Optional.of(headNameCopy);
    }

    public HeadBuilder skinValue(String skinValue) {
        this.skinValue = skinValue;
        return this;
    }

    public HeadBuilder headName(@Nullable String headName) {
        this.headName = headName;
        return this;
    }

    public HeadBuilder signature(@Nullable String signature) {
        this.signature = signature;
        return this;
    }

    public HeadBuilder id(UUID id) {
        this.uuid = id;
        return this;
    }

    public HeadBuilder notAddToHistory() {
        this.addToHeadHistory = false;
        return this;
    }

    public static class_1799 of(String username) {
        class_1799 head = class_1802.field_8575.method_7854();
        head.method_57368(class_9334.field_49617, null, component -> new class_9296(HeadBuilder.safeHeadName(username), Optional.empty(), new PropertyMap()));
        head = ItemUtils.process(head);
        FzmmHistory.addGeneratedHeads(head);
        return head;
    }

    public static class_1799 of(GameProfile profile) {
        class_1799 head = class_1802.field_8575.method_7854();
        head.method_57368(class_9334.field_49617, null, component -> new class_9296(profile));
        head = ItemUtils.process(head);
        FzmmHistory.addGeneratedHeads(head);
        return head;
    }
}

