/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.command.fzmm;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.command.ISubCommand;
import fzmm.zailer.me.client.command.argument_type.ComponentArgumentType;
import fzmm.zailer.me.client.command.argument_type.VersionArgumentType;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1208;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3545;
import net.minecraft.class_3551;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7225;

public class OldGiveCommand
implements ISubCommand {
    @Override
    public String alias() {
        return "old_give";
    }

    @Override
    public String syntax() {
        return "old_give <item> <damage (optional)> <nbt> <version_code>";
    }

    @Override
    public LiteralCommandNode<FabricClientCommandSource> getBaseCommand(class_7157 registryAccess, LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        RequiredArgumentBuilder itemNode = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.fzmm.old_give.nbt_required").method_27692(class_124.field_1061));
            return 1;
        });
        RequiredArgumentBuilder damageNode = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"damage", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.fzmm.old_give.nbt_required").method_27692(class_124.field_1061));
            return 1;
        });
        RequiredArgumentBuilder nbtNode = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"nbt", (ArgumentType)ComponentArgumentType.component()).executes(ctx -> {
            int damage;
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            try {
                damage = (Integer)ctx.getArgument("damage", Integer.TYPE);
            }
            catch (IllegalArgumentException ignored) {
                damage = 0;
            }
            class_2487 nbt = ComponentArgumentType.getNbtCompound(ctx, "nbt");
            OldGiveCommand.oldGiveItem(item, damage, nbt, VersionArgumentType.VERSIONS.get(0));
            return 1;
        });
        RequiredArgumentBuilder versionNode = (RequiredArgumentBuilder)ClientCommandManager.argument((String)"item_version", (ArgumentType)VersionArgumentType.version()).executes(ctx -> {
            int damage;
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            try {
                damage = (Integer)ctx.getArgument("damage", Integer.TYPE);
            }
            catch (IllegalArgumentException ignored) {
                damage = 0;
            }
            class_2487 nbt = ComponentArgumentType.getNbtCompound(ctx, "nbt");
            class_3545<String, Integer> version = VersionArgumentType.getVersion((CommandContext<FabricClientCommandSource>)ctx, "item_version");
            OldGiveCommand.oldGiveItem(item, damage, nbt, version);
            return 1;
        });
        builder.then((CommandNode)((RequiredArgumentBuilder)itemNode.then(nbtNode.then((ArgumentBuilder)versionNode))).build());
        builder.then(itemNode.then(damageNode.then(nbtNode.then((ArgumentBuilder)versionNode))));
        return builder.build();
    }

    private static void oldGiveItem(class_2960 item, int damage, class_2487 nbtCompound, class_3545<String, Integer> oldVersion) {
        CompletableFuture.runAsync(() -> {
            class_5250 errorMessage = class_2561.method_43469((String)"commands.fzmm.old_give.error", (Object[])new Object[]{item.toString(), oldVersion.method_15442()}).method_27692(class_124.field_1061);
            class_338 chatHud = class_310.method_1551().field_1705.method_1743();
            try {
                Optional<class_1799> stackOptional = OldGiveCommand.updateStack(item, damage, nbtCompound, (Integer)oldVersion.method_15441());
                if (stackOptional.isEmpty() || stackOptional.get().method_7960()) {
                    chatHud.method_1812((class_2561)errorMessage);
                } else {
                    ItemUtils.give(ItemUtils.process(stackOptional.get()));
                    chatHud.method_1812((class_2561)class_2561.method_43469((String)"commands.fzmm.old_give.success", (Object[])new Object[]{item.toString(), oldVersion.method_15442()}).method_54663(4689479));
                }
            }
            catch (Exception e) {
                chatHud.method_1812((class_2561)errorMessage);
                FzmmClient.LOGGER.warn("[OldGiveCommand] Failed to update stack with exception:", (Throwable)e);
            }
        });
    }

    public static Optional<class_1799> updateStack(class_2960 item, int damage, class_2487 nbtCompound, int itemVersion) throws Exception {
        try {
            class_2487 itemNbt = OldGiveCommand.writeNbt(item, damage, nbtCompound, itemVersion);
            return OldGiveCommand.updateStack(itemNbt, itemVersion).flatMap(nbtElement -> class_1799.method_57360((class_7225.class_7874)FzmmUtils.getRegistryManager(), (class_2520)nbtElement));
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[OldGiveCommand] Failed to update item with '/fzmm old_give': {}:{} (damage: {})", new Object[]{item.toString(), nbtCompound.toString(), damage});
            throw e;
        }
    }

    public static Optional<class_2520> updateStack(class_2487 nbtCompound, int itemVersion) throws Exception {
        return Optional.of((class_2520)class_3551.method_15450().update(class_1208.field_5712, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbtCompound), itemVersion, class_155.method_16673().method_37912().method_38494()).getValue());
    }

    public static class_2487 writeNbt(class_2960 item, int damage, class_2487 nbtCompound, int itemVersion) {
        boolean isCompound = itemVersion > 3700;
        class_2487 result = new class_2487();
        result.method_10567(isCompound ? "count" : "Count", (byte)1);
        result.method_10582("id", item.toString());
        result.method_10566(isCompound ? "components" : "tag", (class_2520)nbtCompound);
        if (itemVersion <= 1343) {
            result.method_10569("Damage", damage);
        }
        return result;
    }
}

